/*
 * Decompiled with CFR 0.152.
 */
package ustimaw;

import java.util.Calendar;
import robocode.Robot;
import robocode.util.Utils;
import ustimaw.EnemyStatus;
import ustimaw.Position;
import ustimaw.Prediction;

class CircularPredictor {
    private long lastTime;
    private double lastHeading;
    private double headingDelta;
    private double velocity;
    private Position position;

    CircularPredictor() {
    }

    void update(EnemyStatus e) {
        long t = e.sre.getTime();
        if (t <= this.lastTime) {
            return;
        }
        double c = e.sre.getHeadingRadians();
        double f = 0.5;
        this.headingDelta = this.headingDelta * f + (1.0 - f) * Utils.normalRelativeAngle((double)((c - this.lastHeading) / (double)(t - this.lastTime)));
        this.lastHeading = c;
        this.lastTime = t;
        this.position = e.getPoint();
        this.velocity = e.sre.getVelocity();
    }

    private double getNormalMinute() {
        return (double)Calendar.getInstance().get(12) / 60.0;
    }

    Prediction getPrediction(Robot r) {
        Prediction p = new Prediction(this.position, this.lastHeading, this.headingDelta, this.velocity);
        int i = 0;
        while ((long)i < r.getTime() - this.lastTime) {
            p.advance();
            ++i;
        }
        return p;
    }
}

