/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import pa3k.BulletTracking;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.Tracking;
import pa3k.TronAiming;
import pa3k.TronAimingSquareDataStorage;
import pa3k.TronAimingSquareInfo;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class TronAimingSquare
extends TronAiming {
    protected int[] rankingBins;

    public TronAimingSquare(AdvancedRobot advancedRobot, String string, boolean bl) {
        super(advancedRobot, string, bl);
        this.rankingBins = TronAimingSquareDataStorage.getRankingBins(string);
    }

    @Override
    public BulletTracking getBestAimingAngle(Position position, Opponent opponent, Tracking tracking, double d, long l) {
        int n;
        BulletTracking bulletTracking = this.createBulletTracking(position, opponent, tracking, d, l);
        TronAimingSquareInfo tronAimingSquareInfo = new TronAimingSquareInfo(this.getPositiveBins(bulletTracking, 0.9, 1.0, -0.2, 0.1, 1.5, 1.0, 10000), this.getNegativeBins(bulletTracking, 0.9, 1.0, -0.2, 0.1, 1.5, 1.0, 10000));
        bulletTracking.setAimingInfo(tronAimingSquareInfo);
        double[] dArray = tronAimingSquareInfo.getBins();
        int[] nArray = new int[this.rankingBins.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 0;
        }
        n = tronAimingSquareInfo.getMaxIndex();
        int n2 = tronAimingSquareInfo.getMinIndex();
        for (int i = 0; i < dArray.length; ++i) {
            if (Math.abs(n - i) > dArray.length / 3) continue;
            double d2 = dArray[i];
            int n3 = (int)(((d2 - dArray[n2]) / (dArray[n] - dArray[n2]) - 1.0E-5) * (double)this.rankingBins.length);
            nArray[n3] = nArray[n3] + 1;
        }
        int[] nArray2 = nArray;
        int n4 = nArray2.length;
        for (int i = 0; i < n4; ++i) {
            int n5 = nArray2[i];
            Log.log(3, "" + n5);
        }
        int n6 = this.rankingBins.length - 1;
        for (n4 = 0; n4 < this.rankingBins.length; ++n4) {
            if (nArray[n4] == 0 || nArray[n6] != 0 && this.rankingBins[n4] / nArray[n4] <= this.rankingBins[n6] / nArray[n6]) continue;
            n6 = n4;
        }
        Log.log(3, "Selecting the group " + n6 + " with " + this.rankingBins[n6] + "/" + nArray[n6]);
        n4 = n;
        if (this.rankingBins[n6] > 0 && nArray[n6] > 0) {
            int[] nArray3 = new int[dArray.length];
            double d3 = 0.0;
            int n7 = 0;
            for (int i = 0; i < dArray.length; ++i) {
                double d4;
                if (Math.abs(n - i) > dArray.length / 2 || !((d4 = (dArray[i] - dArray[n2]) / (dArray[n] - dArray[n2])) >= (double)n6 / (double)this.rankingBins.length) || !(d4 <= ((double)n6 + 1.0) / (double)this.rankingBins.length)) continue;
                Log.log(3, "  bins[" + i + "] = " + dArray[i] + "(" + d4 + ")");
                nArray3[n7++] = i;
                d3 += dArray[i];
            }
            n4 = nArray3[0];
            double d5 = 0.0;
            double d6 = Utils.getRandom().nextDouble() * d3;
            for (int i = 0; i < n7; ++i) {
                double d7 = (dArray[nArray3[i]] - dArray[n2]) / (dArray[n] - dArray[n2]);
                if (!(d6 <= d7 + d5)) continue;
                d5 += d7;
                n4 = nArray3[i];
                break;
            }
        }
        double d8 = bulletTracking.middleAngle + bulletTracking.getAngleAdvance() * (double)(n4 - tronAimingSquareInfo.getNegBinsCount() + 1);
        bulletTracking.setFiringAngle(d8);
        tronAimingSquareInfo.paintBins(4, bulletTracking, Color.WHITE, 0);
        Log.paintLine(2, position, d8, Color.RED, 0);
        return bulletTracking;
    }

    @Override
    public double[] getEscapeBins(BulletTracking bulletTracking) {
        return super.getEscapeBins(bulletTracking);
    }

    @Override
    public void dumpStats() {
        super.dumpStats();
        for (int i = 0; i < this.rankingBins.length; ++i) {
            Log.log(1, "Ranking " + 100 * i / this.rankingBins.length + "%: " + this.rankingBins[i]);
        }
    }

    protected void processEnemyPosition(BulletTracking bulletTracking) {
        if (this.possibleHits.size() + this.hits.size() < 15) {
            return;
        }
        TronAimingSquareInfo tronAimingSquareInfo = (TronAimingSquareInfo)bulletTracking.getAimingInfo();
        if (tronAimingSquareInfo != null) {
            int n;
            double d = tronAimingSquareInfo.possibleHit(bulletTracking);
            Log.log(3, "Enemy position rating: " + d);
            int n2 = n = (int)(d * ((double)this.rankingBins.length - 1.0E-4));
            this.rankingBins[n2] = this.rankingBins[n2] + 1;
        }
    }

    @Override
    public void hit(BulletTracking bulletTracking) {
        this.processEnemyPosition(bulletTracking);
        super.hit(bulletTracking);
    }

    @Override
    public void possibleHit(BulletTracking bulletTracking) {
        this.processEnemyPosition(bulletTracking);
        super.possibleHit(bulletTracking);
    }
}

