/*
 * Decompiled with CFR 0.152.
 */
package execution;

import execution.INotifiable;
import execution.Message;
import execution.MessageRouter;
import execution.OneOnOneRadarListener$$Lambda$1;
import execution.OneOnOneRadarListener$$Lambda$2;
import execution.Sequencer;
import robocode.util.Utils;
import sim.Bot;
import sim.Data;
import sim.Stat;

public class OneOnOneRadarListener
implements INotifiable {
    private Sequencer _sequencer;

    public OneOnOneRadarListener(Sequencer sequencer) {
        this._sequencer = sequencer;
    }

    @Override
    public void Initialize(MessageRouter router) {
        router.Subscribe(Message.Kind.RoundStarted, OneOnOneRadarListener$$Lambda$1.lambdaFactory$(this));
        router.Subscribe(Message.Kind.ScannedEnemy, OneOnOneRadarListener$$Lambda$2.lambdaFactory$(this));
    }

    private final void RoundStarted(Message message) {
        this._sequencer.scan.set(Double.POSITIVE_INFINITY);
    }

    private final void EnemyScanned(Message message) {
        Bot enemy = Data.Robots.Enemy(message.subject);
        Bot self = Data.Robots.Self;
        double absoluteBearing = enemy.Get(Stat.ABSOLUTEBEARING);
        double radarTurn = absoluteBearing - self.Get(Stat.RADAR_HEADING);
        double turnAngle = Utils.normalRelativeAngle((double)radarTurn);
        double crossSection = enemy.Get(Stat.RADAR_CROSSSECTION);
        double wobbleMax = Math.signum(turnAngle) * crossSection / 2.0;
        this._sequencer.scan.set(turnAngle + wobbleMax);
    }

    static /* synthetic */ void access$lambda$0(OneOnOneRadarListener oneOnOneRadarListener, Message message) {
        oneOnOneRadarListener.RoundStarted(message);
    }

    static /* synthetic */ void access$lambda$1(OneOnOneRadarListener oneOnOneRadarListener, Message message) {
        oneOnOneRadarListener.EnemyScanned(message);
    }
}

