/*
 * Decompiled with CFR 0.152.
 */
package util;

public class CircularBuffer {
    private final int _length;
    private final double[] _buffer;
    private final long[] _times;

    public CircularBuffer(int capacity) {
        this._length = capacity + 1;
        this._buffer = new double[this._length];
        this._times = new long[this._length];
    }

    public Double Get(long time) {
        int index = this.WrapIndex(time);
        if (this._times[index] == time) {
            return this._buffer[index];
        }
        return null;
    }

    public void Set(double item, long time) {
        int index = this.WrapIndex(time);
        this._buffer[index] = item;
        this._times[index] = time;
    }

    private int WrapIndex(long i) {
        long m = i % (long)this._length;
        if (m < 0L) {
            m += (long)this._length;
        }
        return (int)m;
    }
}

