/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.data;

import dmh.robocode.utils.ConvertStatistic;
import robocode.util.Utils;

public class Movement {
    private short relativeBearingTimesTen;
    private short distanceTimesTen;

    public Movement(double relativeBearing, double distance) {
        this.relativeBearingTimesTen = ConvertStatistic.makeShort(Utils.normalRelativeAngleDegrees((double)relativeBearing) * 10.0);
        this.distanceTimesTen = ConvertStatistic.makeShort(distance * 10.0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.distanceTimesTen;
        result = 31 * result + this.relativeBearingTimesTen;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Movement other = (Movement)obj;
        if (this.distanceTimesTen != other.distanceTimesTen) {
            return false;
        }
        return this.relativeBearingTimesTen == other.relativeBearingTimesTen;
    }

    public double getRelativeBearing() {
        return (double)this.relativeBearingTimesTen / 10.0;
    }

    public double getDistance() {
        return (double)this.distanceTimesTen / 10.0;
    }

    public String getDebugString() {
        return "[ " + (double)this.relativeBearingTimesTen / 10.0 + ", " + (double)this.distanceTimesTen / 10.0 + " ]";
    }
}

