/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.aiming;

import dmh.robocode.data.Location;
import dmh.robocode.data.PerfectHitMovement;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.aiming.CalibratedAimingStrategy;
import dmh.robocode.robot.CommandBasedRobot;
import java.awt.Color;
import java.util.ArrayList;

public class AimUsingPerfectMovementsA
extends CalibratedAimingStrategy {
    private boolean decisionFixed = false;
    private PerfectHitMovement chosenMovement = null;
    int possibleOptions = 0;

    public AimUsingPerfectMovementsA(CommandBasedRobot myRobot, EnemyRobot enemy, boolean isLearningAllowed, Color color) {
        super(myRobot, enemy, isLearningAllowed, color);
    }

    @Override
    public double getEstimatedSuccessOfShotUsingRules(double bulletSpeed) {
        if (this.getTargetForShot(bulletSpeed) == null) {
            return 0.0;
        }
        return Math.min(100, 10 * this.possibleOptions);
    }

    @Override
    public Location getTargetForShot(double bulletSpeed) {
        this.makeDecision(bulletSpeed);
        if (this.chosenMovement == null) {
            return null;
        }
        return this.chosenMovement.applyRelativeMovement(this.getEnemy().getLatestRadarObservation().getLocation(), this.getEnemy().getLatestRadarObservation().getHeading());
    }

    private void makeDecision(double bulletSpeed) {
        if (!this.decisionFixed) {
            byte enemyZone = this.getEnemy().getLatestRadarObservation().getLocation().getZone();
            ArrayList<PerfectHitMovement> movements = this.getEnemy().getPerfectHitMovementsByZone().get(enemyZone);
            if (movements == null) {
                this.chosenMovement = null;
            } else {
                this.possibleOptions = movements.size();
                this.chosenMovement = movements.get((int)Math.floor(Math.random() * (double)this.possibleOptions));
            }
            this.decisionFixed = true;
        }
    }

    @Override
    public void notifyShotJustFired() {
        super.notifyShotJustFired();
        this.decisionFixed = false;
    }
}

