/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.simulator;

import dmh.robocode.data.Location;
import dmh.robocode.gunner.simulator.EnemySimulator;
import dmh.robocode.utils.Geometry;

public class SteadyChangeEnemySimulator
implements EnemySimulator {
    private Location location;
    private double velocity;
    private double heading;
    private double acceleration;
    private double rateOfTurn;
    private double minVelocity;
    private double maxVelocity;

    public SteadyChangeEnemySimulator(Location location, double velocity, double heading, double acceleration, double rateOfTurn) {
        this.location = location;
        this.velocity = velocity;
        this.heading = heading;
        this.acceleration = acceleration;
        this.rateOfTurn = rateOfTurn;
        switch ((int)Math.signum(velocity)) {
            case 0: {
                this.minVelocity = -8.0;
                this.maxVelocity = 8.0;
                break;
            }
            case 1: {
                this.minVelocity = 0.0;
                this.maxVelocity = 8.0;
                break;
            }
            case -1: {
                this.minVelocity = -8.0;
                this.maxVelocity = 0.0;
            }
        }
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void takeOneTurn() {
        this.location = Geometry.getLocationAtBearing(this.location, this.heading, this.velocity);
        this.heading += this.rateOfTurn;
        this.velocity = Math.max(Math.min(this.velocity + this.acceleration, this.maxVelocity), this.minVelocity);
    }

    public static double getNewVelocityWithoutChangeOfDirection(double oldVelocity, double acceleration) {
        double newVelocity = oldVelocity + acceleration;
        if (Math.abs(newVelocity) > 8.0) {
            newVelocity = 8.0 * Math.signum(newVelocity);
        }
        if (newVelocity < 0.0 && oldVelocity > 0.0 || newVelocity > 0.0 && oldVelocity < 0.0) {
            newVelocity = 0.0;
        }
        return newVelocity;
    }
}

