/*
 * Decompiled with CFR 0.152.
 */
package oog.melee;

import robocode.AdvancedRobot;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Corsair
extends AdvancedRobot {
    static String enemyName;
    static double enemyDist;
    static double dist;

    public void run() {
        enemyDist = Double.POSITIVE_INFINITY;
        dist = Double.POSITIVE_INFINITY;
        this.setAdjustGunForRobotTurn(true);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (e.getDistance() < enemyDist || e.getName() == enemyName) {
            enemyName = e.getName();
            double absBearing = e.getBearingRadians();
            enemyDist = e.getDistance();
            this.setTurnRightRadians(Math.cos(absBearing) + Math.sin((double)this.getTime() / (enemyDist / 50.0)) * 0.85);
            this.setAhead((Math.abs(absBearing) - 1.5707963267948966) * (dist - enemyDist) * Double.POSITIVE_INFINITY);
            double bulletPower = Math.min(3.0, Math.max(0.1, Math.min(e.getEnergy() / 3.0, 500.0 / enemyDist)));
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)((absBearing += this.getHeadingRadians()) - this.getGunHeadingRadians())) + e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing) / (20.0 - 3.0 * bulletPower));
            this.setFire(bulletPower);
            if (this.getGunHeat() < 1.0) {
                this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
            }
        }
    }

    public void onHitWall(HitWallEvent e) {
        dist = enemyDist * 0.75;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        dist = Double.POSITIVE_INFINITY;
        enemyDist = Double.POSITIVE_INFINITY;
    }
}

