/*
 * Decompiled with CFR 0.152.
 */
package catcat20;

import catcat20.Lambda;
import catcat20.move.Surfing;
import catcat20.utils.LConstants;
import catcat20.utils.LUtils;
import catcat20.utils.SimplexNoise;
import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class Rabbit
extends Lambda {
    public Rabbit() {
        Surfing.RABBIT_MODE = true;
    }

    @Override
    public void setDefaultColor() {
        float pink = 230.0f;
        float pinkWhite = 254.5f;
        float blueMul = 2.5f;
        float pinkWhiteRan = (float)(Math.random() * 0.0) / 255.0f;
        float pinkRan = (float)(Math.random() * 10.0) / 255.0f;
        float green = 0.0f;
        this.setBodyColor(new Color(1.0f, pinkWhite / 255.0f + pinkWhiteRan, pinkWhite / 255.0f + pinkWhiteRan));
        float gunCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        this.setGunColor(new Color(1.0f, pinkWhite / 255.0f + pinkWhiteRan, pinkWhite / 255.0f + pinkWhiteRan));
        float radarCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        this.setRadarColor(new Color(1.0f, pink / 255.0f + pinkRan, pink / 255.0f + pinkRan));
        float scanArcCol = (float)(Math.random() * 5.0 + 75.0) / 255.0f;
        this.setScanColor(new Color(1.0f, pink / 255.0f + pinkRan, pink / 255.0f + pinkRan));
        float bulCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        this.setBulletColor(new Color(1.0f, pink / 255.0f + pinkRan, pink / 255.0f + pinkRan));
    }

    @Override
    public void setWinColor() {
        float blueMul = 2.5f;
        float bodyCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        float green = 0.9882353f;
        float greenRan = 2.8f;
        float gunCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        float radarCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        float scanArcCol = (float)(Math.random() * 5.0 + 75.0) / 255.0f;
        float bulCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        double mapSize = 250.0;
        double noise = (SimplexNoise.noise(this.getX() / mapSize, this.getY() / mapSize) + 1.0) / 2.0;
        blueMul = 2.5f;
        bodyCol = (float)(noise * (double)greenRan + 0.0) / 255.0f;
        this.setBodyColor(new Color(1.0f, green + bodyCol, bodyCol + green));
        gunCol = (float)(noise * (double)greenRan + 0.0) / 255.0f;
        this.setGunColor(new Color(1.0f, green + gunCol, gunCol + green));
        radarCol = (float)(noise * (double)greenRan + 0.0) / 255.0f;
        this.setRadarColor(new Color(1.0f, green + radarCol, radarCol + green));
        blueMul = 2.0f;
        scanArcCol = (float)(noise * (double)greenRan + 0.0) / 255.0f;
        this.setScanColor(new Color(1.0f, green + scanArcCol, scanArcCol + green));
        bulCol = (float)(noise * (double)greenRan + 0.0) / 255.0f;
        this.setBulletColor(new Color(1.0f, green + bulCol, bulCol + green));
    }

    @Override
    public void winMove() {
        this.setMaxVelocity(Surfing.getRabbitVelocity(this.getTime()));
        this.setAdjustGunForRobotTurn(false);
        this.setAdjustRadarForGunTurn(false);
        this.setAdjustRadarForRobotTurn(false);
        double power = 3.0;
        power = Math.min(this.getEnergy() - 0.1, power);
        if (this.getEnergy() > power + 0.1) {
            this.setFire(power);
        }
        this.setTurnGunRightRadians(Double.POSITIVE_INFINITY * (double)this.winDirection * 1.0);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY * (double)this.winDirection * 1.0);
        double angle = LUtils.absoluteBearing(this.getX(), this.getY(), LConstants.fieldCenter.x, LConstants.fieldCenter.y);
        this.trig.sin = Math.sin(angle -= 1.5707963267948966 * (double)this.winDirection * 1.5);
        this.trig.cos = Math.cos(angle);
        angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, this.getX(), this.getY(), this.winDirection);
        this.trig.sin = Math.sin(angle);
        this.trig.cos = Math.cos(angle);
        angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, this.getX(), this.getY(), this.winDirection);
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(angle - this.getHeadingRadians())));
        Rabbit.setBackAsFront((AdvancedRobot)this, angle);
    }
}

