/*
 * Decompiled with CFR 0.152.
 */
package Svasta;

import java.awt.geom.Point2D;
import robocode.util.Utils;

public class Wave {
    private double x;
    private double y;
    private double bearing;
    private double power;
    private int fireTime;
    private int direction;
    private int[] returnSegment;

    public Wave(double x, double y, double bearing, double power, int direction, int time, int[] segment) {
        this.x = x;
        this.y = y;
        this.bearing = bearing;
        this.power = power;
        this.fireTime = time;
        this.direction = direction;
        this.returnSegment = segment;
    }

    public double getBulletSpeed() {
        return 20.0 - this.power * 3.0;
    }

    public double maxEscapeAngle() {
        return Math.asin(8.0 / this.getBulletSpeed());
    }

    public boolean checkHit(double hostileX, double hostileY, int time) {
        if (Point2D.distance(this.x, this.y, hostileX, hostileY) <= (double)(time - this.fireTime) * this.getBulletSpeed()) {
            int index;
            double desiredDirection = Math.atan2(hostileX - this.x, hostileY - this.y);
            double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - this.bearing));
            double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / this.maxEscapeAngle())) * (double)this.direction;
            int n = index = (int)Math.round((double)((this.returnSegment.length - 1) / 2) * (guessFactor + 1.0));
            this.returnSegment[n] = this.returnSegment[n] + 1;
            return true;
        }
        return false;
    }
}

