/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.utils.knn;

import ags.utils.dataStructures.trees.thirdGenKD.DistanceFunction;
import ags.utils.dataStructures.trees.thirdGenKD.KdTree;
import ags.utils.dataStructures.trees.thirdGenKD.NearestNeighborIterator;
import ags.utils.dataStructures.trees.thirdGenKD.WeightedManhattanDistanceFunction;
import catcat20.core.utils.knn.KNNData;
import java.util.ArrayList;

public class KNNModel<T> {
    public KdTree<T> tree;
    public double treeWeight = 1.0;
    public double[] weights;
    public DistanceFunction distanceFunction;

    public KNNModel(double[] weights) {
        this.distanceFunction = new WeightedManhattanDistanceFunction(weights);
        this.tree = new KdTree(weights.length);
        this.weights = weights;
    }

    public KNNModel(double[] weights, DistanceFunction distanceFunction) {
        this.distanceFunction = distanceFunction;
        this.tree = new KdTree(weights.length);
        this.weights = weights;
    }

    public void addPoint(double[] dataPoint, T data) {
        try {
            this.tree.addPoint(dataPoint, (Object)data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<KNNData<T>> getNearestNeighborsList(double[] dataPoint, int k) {
        NearestNeighborIterator<T> neighbors = this.tree.getNearestNeighborIterator(dataPoint, k, this.distanceFunction);
        ArrayList<KNNData<T>> list = new ArrayList<KNNData<T>>();
        int dataCount = 0;
        for (T data : neighbors) {
            KNNData dataset = new KNNData();
            dataset.order = ++dataCount;
            dataset.distance = neighbors.distance();
            dataset.data = data;
            dataset.treeWeight = this.treeWeight;
            list.add(dataset);
        }
        return list;
    }
}

