/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.linear;

import org.la4j.LinearAlgebra;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.Vectors;
import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.linear.AbstractSolver;
import org.la4j.linear.LinearSystemSolver;

public class LeastSquaresSolver
extends AbstractSolver
implements LinearSystemSolver {
    private static final long serialVersionUID = 4071505L;
    private final Matrix qr;
    private final Matrix r;

    public LeastSquaresSolver(Matrix a) {
        super(a);
        MatrixDecompositor decompositor = a.withDecompositor(LinearAlgebra.RAW_QR);
        Matrix[] qrr = decompositor.decompose();
        this.qr = qrr[0];
        this.r = qrr[1];
    }

    @Override
    public Vector solve(Vector b) {
        int j;
        this.ensureRHSIsCorrect(b);
        int n = this.unknowns();
        int m = this.equations();
        for (int i = 0; i < this.r.rows(); ++i) {
            if (this.r.get(i, i) != 0.0) continue;
            this.fail("This system can not be solved: coefficient matrix is rank deficient.");
        }
        Vector x = b.copy();
        for (j = 0; j < n; ++j) {
            int i;
            double acc = 0.0;
            for (i = j; i < m; ++i) {
                acc += this.qr.get(i, j) * x.get(i);
            }
            acc = -acc / this.qr.get(j, j);
            for (i = j; i < m; ++i) {
                x.updateAt(i, Vectors.asPlusFunction(acc * this.qr.get(i, j)));
            }
        }
        for (j = n - 1; j >= 0; --j) {
            x.updateAt(j, Vectors.asDivFunction(this.r.get(j, j)));
            for (int i = 0; i < j; ++i) {
                x.updateAt(i, Vectors.asMinusFunction(x.get(j) * this.qr.get(i, j)));
            }
        }
        return x.slice(0, n);
    }

    @Override
    public boolean applicableTo(Matrix matrix) {
        return matrix.rows() >= matrix.columns();
    }
}

