/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.util.HashMap;
import java.util.Map;
import mue.FireSnapshot;
import mue.GunBase;
import mue.Position;
import mue.RobotData;
import mue.Util;
import robocode.AdvancedRobot;

class GuessFactorGun
extends GunBase {
    protected static final int GUESS_BUCKETS = 23;
    protected static final int[] DISTANCE_BUCKETS = new int[]{180, 360, 540, 720};
    protected static final int[] FAST_DISTANCE_BUCKETS = new int[]{250, 600};
    protected static final int[] VELOCITY_BUCKETS = new int[]{1, 3, 5, 7};
    protected static final int[] FAST_VELOCITY_BUCKETS = new int[]{2, 5};
    protected static final double[] VELCHANGED_BUCKETS = new double[]{1.0E-4, 0.1, 0.3, 0.6, 1.0};
    protected static final double[] FAST_VELCHANGED_BUCKETS = new double[]{0.1, 0.4, 0.8};
    protected static final double[] WALL_BUCKETS = new double[]{0.2, 0.5, 0.8, 1.2};
    protected static final double[] FAST_WALL_BUCKETS = new double[]{0.4, 0.9};
    protected static final double[] REVERSE_WALL_BUCKETS = new double[]{-0.35, -0.8};
    protected static final int CONSTANTSPEED = 0;
    protected static final int ACCELERATION = 1;
    protected static final int DECELERATION = 2;
    protected static final float ROLLING_FACTOR = 0.006f;
    protected static final float FAST_ROLLING_FACTOR = 0.008f;
    protected static final float VIRTUAL_ROLLING_FACTOR = 0.002f;
    protected static final float FAST_VIRTUAL_ROLLING_FACTOR = 0.0026666669f;
    protected static Map targetDatas = null;

    public GuessFactorGun(AdvancedRobot advancedRobot) {
        super(advancedRobot, "GuessFactorGun");
        if (targetDatas == null) {
            targetDatas = new HashMap(10);
        }
    }

    protected double getFireAngle(Position position, RobotData robotData, double d, long l) {
        Position position2 = robotData.guessPosition();
        double d2 = Util.direction(position.getX(), position.getY(), position2.getX(), position2.getY());
        TargetData targetData = (TargetData)targetDatas.get(robotData.getName());
        if (targetData == null) {
            return d2;
        }
        double d3 = targetData.getGuessFactor(position.getX(), position.getY(), position2.getX(), position2.getY(), robotData.getVelocity(), robotData.getOrbitDirection(), robotData.getTimeSinceLastAcceleration(), robotData.getTimeSinceLastDeceleration(), d);
        double d4 = Util.distance(position.getX(), position.getY(), position2.getX(), position2.getY());
        d3 *= Math.toDegrees(Math.asin(8.0 * Math.ceil(d4 / (20.0 - 3.0 * d)) / d4));
        if (robotData.getOrbitDirection() == -1) {
            d3 *= -1.0;
        }
        return d2 + d3;
    }

    public void onScanWave(String string, FireSnapshot fireSnapshot, double d, double d2, boolean bl) {
        TargetData targetData;
        double d3 = Util.direction(fireSnapshot.getOriginX(), fireSnapshot.getOriginY(), d, d2);
        double d4 = Math.toDegrees(Math.atan(20.0 / fireSnapshot.getDistance()));
        double d5 = fireSnapshot.getGuessFactor(d3 - d4);
        double d6 = fireSnapshot.getGuessFactor(d3 + d4);
        if (d6 < d5) {
            double d7 = d5;
            d5 = d6;
            d6 = d7;
        }
        if ((targetData = (TargetData)targetDatas.get(string)) == null) {
            targetData = new TargetData(this.getBattleFieldWidth(), this.getBattleFieldHeight());
            targetDatas.put(string, targetData);
        }
        targetData.adapt(fireSnapshot.getOriginX(), fireSnapshot.getOriginY(), fireSnapshot.getTargetX(), fireSnapshot.getTargetY(), fireSnapshot.getVelocity(), fireSnapshot.getOrbitDirection(), fireSnapshot.getTimeSinceLastAcceleration(), fireSnapshot.getTimeSinceLastDeceleration(), fireSnapshot.getPower(), d5, d6, bl);
    }

    protected static final class TargetData {
        private float[][][][][][][] guessFactors = new float[DISTANCE_BUCKETS.length + 1][VELOCITY_BUCKETS.length + 1][3][WALL_BUCKETS.length + 1][REVERSE_WALL_BUCKETS.length + 1][VELCHANGED_BUCKETS.length + 1][47];
        private float[][][][][][] fastGuessFactors = new float[FAST_DISTANCE_BUCKETS.length + 1][FAST_VELOCITY_BUCKETS.length + 1][3][FAST_WALL_BUCKETS.length + 1][FAST_VELCHANGED_BUCKETS.length + 1][47];
        private double battleFieldWidth;
        private double battleFieldHeight;

        public TargetData(double d, double d2) {
            this.battleFieldWidth = d;
            this.battleFieldHeight = d2;
        }

        private boolean isInsideField(double d, double d2) {
            return d >= 18.0 && d <= this.battleFieldWidth - 18.0 && d2 >= 18.0 && d2 <= this.battleFieldHeight - 18.0;
        }

        private float[] getSegment(double d, double d2, double d3, double d4, double d5, int n, int n2, int n3, double d6) {
            double d7;
            double d8;
            int n4 = (int)Math.round(Util.distance(d, d2, d3, d4));
            int n5 = Math.abs((int)Math.round(d5));
            int n6 = Util.findSegmentationIndex(DISTANCE_BUCKETS, n4);
            int n7 = Util.findSegmentationIndex(VELOCITY_BUCKETS, n5);
            int n8 = 0;
            if (n2 < n3) {
                n8 = 1;
            }
            if (n2 > n3) {
                n8 = 2;
            }
            double d9 = Util.directionRadians(d, d2, d3, d4);
            double d10 = Math.asin(8.0 / (20.0 - 3.0 * d6));
            if (n == -1) {
                d10 *= -1.0;
            }
            int n9 = 0;
            while (n9 < WALL_BUCKETS.length) {
                d8 = d + Math.sin(d9 + d10 * WALL_BUCKETS[n9]) * (double)n4;
                if (!this.isInsideField(d8, d7 = d2 + Math.cos(d9 + d10 * WALL_BUCKETS[n9]) * (double)n4)) break;
                ++n9;
            }
            int n10 = 0;
            while (n10 < REVERSE_WALL_BUCKETS.length) {
                d8 = d + Math.sin(d9 + d10 * REVERSE_WALL_BUCKETS[n10]) * (double)n4;
                if (!this.isInsideField(d8, d7 = d2 + Math.cos(d9 + d10 * REVERSE_WALL_BUCKETS[n10]) * (double)n4)) break;
                ++n10;
            }
            int n11 = Math.min(n2, n3);
            int n12 = Util.findSegmentationIndex(VELCHANGED_BUCKETS, (double)n11 * (20.0 - 3.0 * d6) / (double)n4);
            return this.guessFactors[n6][n7][n8][n9][n10][n12];
        }

        private float[] getFastSegment(double d, double d2, double d3, double d4, double d5, int n, int n2, int n3, double d6) {
            int n4 = (int)Math.round(Util.distance(d, d2, d3, d4));
            int n5 = Math.abs((int)Math.round(d5));
            int n6 = Util.findSegmentationIndex(FAST_DISTANCE_BUCKETS, n4);
            int n7 = Util.findSegmentationIndex(FAST_VELOCITY_BUCKETS, n5);
            int n8 = 0;
            if (n2 < n3) {
                n8 = 1;
            }
            if (n2 > n3) {
                n8 = 2;
            }
            double d7 = Util.directionRadians(d, d2, d3, d4);
            double d8 = Math.asin(8.0 / (20.0 - 3.0 * d6));
            if (n == -1) {
                d8 *= -1.0;
            }
            int n9 = 0;
            while (n9 < FAST_WALL_BUCKETS.length) {
                double d9;
                double d10 = d + Math.sin(d7 + d8 * FAST_WALL_BUCKETS[n9]) * (double)n4;
                if (!this.isInsideField(d10, d9 = d2 + Math.cos(d7 + d8 * FAST_WALL_BUCKETS[n9]) * (double)n4)) break;
                ++n9;
            }
            int n10 = Math.min(n2, n3);
            int n11 = Util.findSegmentationIndex(FAST_VELCHANGED_BUCKETS, (double)n10 * (20.0 - 3.0 * d6) / (double)n4);
            return this.fastGuessFactors[n6][n7][n8][n9][n11];
        }

        public double getGuessFactor(double d, double d2, double d3, double d4, double d5, int n, int n2, int n3, double d6) {
            float[] fArray = this.getSegment(d, d2, d3, d4, d5, n, n2, n3, d6);
            float[] fArray2 = this.getFastSegment(d, d2, d3, d4, d5, n, n2, n3, d6);
            float f = 0.001f;
            float f2 = 0.001f;
            int n4 = 46;
            while (n4 >= 0) {
                if (fArray[n4] > f) {
                    f = fArray[n4];
                }
                if (fArray2[n4] > f2) {
                    f2 = fArray2[n4];
                }
                --n4;
            }
            f = 0.5f / f;
            f2 = 0.5f / f2;
            n4 = 23;
            float f3 = 0.0f;
            int n5 = 46;
            while (n5 >= 0) {
                float f4 = f * fArray[n5] + f2 * fArray2[n5];
                if (f4 > f3) {
                    f3 = f4;
                    n4 = n5;
                }
                --n5;
            }
            return (double)(n4 - 23) / 23.0;
        }

        public void adapt(double d, double d2, double d3, double d4, double d5, int n, int n2, int n3, double d6, double d7, double d8, boolean bl) {
            int n4 = Util.confine((int)Math.round(d7 * 23.0 + 23.0), 0, 46);
            int n5 = Util.confine((int)Math.round(d8 * 23.0 + 23.0), 0, 46);
            float[] fArray = this.getSegment(d, d2, d3, d4, d5, n, n2, n3, d6);
            float[] fArray2 = this.getFastSegment(d, d2, d3, d4, d5, n, n2, n3, d6);
            float f = bl ? 0.006f : 0.002f;
            float f2 = bl ? 0.008f : 0.0026666669f;
            int n6 = 0;
            while (n6 <= 46) {
                int n7 = n6;
                fArray[n7] = fArray[n7] * (1.0f - f);
                int n8 = n6++;
                fArray2[n8] = fArray2[n8] * (1.0f - f2);
            }
            if (n4 == n5) {
                int n9 = n4;
                fArray[n9] = fArray[n9] + f;
                int n10 = n4;
                fArray2[n10] = fArray2[n10] + f2;
            } else {
                float f3 = 1.5876f / (float)((n5 - n4) * (n5 - n4));
                float f4 = (float)(n4 + n5) / 2.0f;
                int n11 = n5;
                while (n11 >= n4) {
                    int n12 = n11;
                    fArray[n12] = fArray[n12] + f * (1.0f - f3 * ((float)n11 - f4) * ((float)n11 - f4));
                    int n13 = n11;
                    fArray2[n13] = fArray2[n13] + f2 * (1.0f - f3 * ((float)n11 - f4) * ((float)n11 - f4));
                    --n11;
                }
            }
        }
    }
}

