/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.util.Arrays;
import mue.HitStatistic;
import mue.Util;

class VirtualHitStatistic
extends HitStatistic {
    private float rollingHitRatio;
    private float[] rollingHitRatios;
    private float hitRollingFactor;
    private float missRollingFactor;

    public VirtualHitStatistic(int[] nArray, float f, float f2, float f3) {
        super(nArray);
        this.hitRollingFactor = f2;
        this.missRollingFactor = f3;
        this.rollingHitRatio = f;
        this.rollingHitRatios = new float[nArray.length + 1];
        Arrays.fill(this.rollingHitRatios, f);
    }

    public void addHit(int n, double d) {
        super.addShot(n, d);
        super.addHit(n, d);
        int n2 = Util.findSegmentationIndex(this.buckets, n);
        this.rollingHitRatios[n2] = this.hitRollingFactor + (1.0f - this.hitRollingFactor) * this.rollingHitRatios[n2];
        this.rollingHitRatio = this.hitRollingFactor + (1.0f - this.hitRollingFactor) * this.rollingHitRatio;
    }

    public void addMiss(int n, double d) {
        super.addShot(n, d);
        int n2 = Util.findSegmentationIndex(this.buckets, n);
        this.rollingHitRatios[n2] = this.rollingHitRatios[n2] * (1.0f - this.missRollingFactor);
        this.rollingHitRatio *= 1.0f - this.missRollingFactor;
    }

    public final float rollingHitRatio(int n) {
        return this.rollingHitRatios[Util.findSegmentationIndex(this.buckets, n)];
    }

    public final float rollingHitRatio() {
        return this.rollingHitRatio;
    }
}

