/*
 * Decompiled with CFR 0.152.
 */
package mue;

import mue.BulletData;
import mue.MovementBase;
import mue.Position;
import mue.RobotBase;
import mue.RobotData;
import mue.Util;

class WaypointMovement
extends MovementBase {
    private String opponent = null;
    private int ticks = 0;
    Position nextPosition = null;
    private double maxDistance = 0.0;
    private double minDistance = 0.0;

    public WaypointMovement(RobotBase robotBase) {
        super(robotBase);
    }

    public void setOpponent(String string) {
        if (this.opponent != null && !this.opponent.equals(string) || this.opponent == null && string != null) {
            this.reset();
        }
        this.opponent = string;
    }

    public String getOpponent() {
        return this.opponent;
    }

    public void setMaxDistance(double d) {
        if (Math.abs(this.maxDistance - d) > 1.0E-4) {
            this.reset();
        }
        this.maxDistance = d;
    }

    public void setMinDistance(double d) {
        if (Math.abs(this.minDistance - d) > 1.0E-4) {
            this.reset();
        }
        this.minDistance = d;
    }

    public void reset() {
        this.ticks = 0;
        this.nextPosition = null;
    }

    public boolean move() {
        double d;
        double d2;
        double d3;
        if (this.opponent == null) {
            return false;
        }
        RobotData robotData = this.getKnowledge().getRobotData(this.opponent);
        if (robotData == null) {
            return false;
        }
        BulletData bulletData = this.getKnowledge().lastBulletFired();
        if (bulletData != null && bulletData.getTime() == this.getTime() - 1L && Math.random() < 0.5) {
            this.ticks = 0;
        }
        if (this.ticks == 0 || this.nextPosition == null) {
            d3 = robotData.getDistance();
            d2 = this.directionTo(robotData);
            d = -50.0;
            double d4 = 50.0;
            double d5 = Math.toRadians(d2 + d - 180.0);
            double d6 = robotData.getX() + Math.sin(d5) * d3;
            double d7 = robotData.getY() + Math.cos(d5) * d3;
            if (d6 < 20.0) {
                d = Util.relativeAngle(d2 + 180.0, Math.toDegrees(Math.asin((20.0 - robotData.getX()) / d3)));
            } else if (d6 > this.getBattleFieldWidth() - 20.0) {
                d = Util.relativeAngle(d2 + 180.0, 180.0 - Math.toDegrees(Math.asin((this.getBattleFieldWidth() - 20.0 - robotData.getX()) / d3)));
            }
            if (d7 < 20.0) {
                d = Util.relativeAngle(d2 + 180.0, -90.0 - Math.toDegrees(Math.asin((robotData.getY() - 20.0) / d3)));
            } else if (d7 > this.getBattleFieldHeight() - 20.0) {
                d = Util.relativeAngle(d2 + 180.0, 90.0 - Math.toDegrees(Math.asin((this.getBattleFieldHeight() - 20.0 - robotData.getY()) / d3)));
            }
            d5 = Math.toRadians(d2 + d4 - 180.0);
            d6 = robotData.getX() + Math.sin(d5) * d3;
            d7 = robotData.getY() + Math.cos(d5) * d3;
            if (d6 < 20.0) {
                d4 = Util.relativeAngle(d2 + 180.0, 180.0 + Math.toDegrees(Math.asin((robotData.getX() - 20.0) / d3)));
            } else if (d6 > this.getBattleFieldWidth() - 20.0) {
                d4 = Util.relativeAngle(d2 + 180.0, Math.toDegrees(Math.asin((this.getBattleFieldWidth() - 20.0 - robotData.getX()) / d3)));
            }
            if (d7 < 20.0) {
                d4 = Util.relativeAngle(d2 + 180.0, 90.0 + Math.toDegrees(Math.asin((robotData.getY() - 20.0) / d3)));
            } else if (d7 > this.getBattleFieldHeight() - 20.0) {
                d4 = Util.relativeAngle(d2 + 180.0, -90.0 + Math.toDegrees(Math.asin((this.getBattleFieldHeight() - 20.0 - robotData.getY()) / d3)));
            }
            d5 = Math.toRadians(Math.random() * (d4 - d) + d);
            double d8 = d3;
            if (this.maxDistance > 0.0 && d3 > this.maxDistance) {
                d8 *= Math.cos(d5);
            }
            if (this.minDistance > 0.0 && d3 < this.minDistance) {
                d8 /= Math.cos(d5);
            }
            this.ticks = (int)(Math.min(d3, d8) / (20.0 - 3.0 * robotData.getAverageFirePower()) * (0.5 + 0.5 * Math.random()));
            d5 = Math.toRadians(d2) + Math.PI + d5;
            d6 = robotData.getX() + Math.sin(d5) * d8;
            d7 = robotData.getY() + Math.cos(d5) * d8;
            if (d6 < 30.0) {
                d6 = 30.0;
            }
            if (d7 < 30.0) {
                d7 = 30.0;
            }
            if (d6 > this.getBattleFieldWidth() - 30.0) {
                d6 = this.getBattleFieldWidth() - 30.0;
            }
            if (d7 > this.getBattleFieldHeight() - 30.0) {
                d7 = this.getBattleFieldHeight() - 30.0;
            }
            this.nextPosition = new Position(d6, d7);
        } else {
            --this.ticks;
        }
        d3 = this.distanceTo(this.nextPosition.getX(), this.nextPosition.getY());
        if (d3 > 0.0) {
            boolean bl = true;
            double d9 = this.directionTo(this.nextPosition.getX(), this.nextPosition.getY());
            if (Math.abs(Util.relativeAngle(this.getHeading(), d9)) > 90.0) {
                bl = false;
                d9 += 180.0;
            }
            if (this.getTurnRemaining() > 50.0) {
                d3 = 1.0;
            }
            if (bl) {
                this.setAhead(d3);
            } else {
                this.setBack(d3);
            }
            this.setTurn(d9);
        } else {
            d2 = this.directionTo(robotData);
            d = d2 + 90.0;
            if (Math.abs(Util.relativeAngle(this.getHeading(), d)) > 90.0) {
                d -= 180.0;
            }
            this.setTurn(d);
        }
        return true;
    }
}

