/*
 * Decompiled with CFR 0.152.
 */
package fwb;

import MGAM.BotInfo;
import MGAM.BotMaster;
import MGAM.Vec2D;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class FWBBotInfo
extends BotInfo {
    public double dAbsoluteBearingRadians;
    public double dLastHeading;

    @Override
    public void update(ScannedRobotEvent e, BotMaster bot) {
        this.dDistance = e.getDistance();
        this.dEnergy = e.getEnergy();
        this.dBearingRad = e.getBearingRadians();
        this.dAbsoluteBearingRadians = Utils.normalAbsoluteAngle((double)(bot.self.botInfo.dHeadingRad + this.dBearingRad));
        this.dLastHeading = this.dHeadingRad;
        this.dHeadingRad = e.getHeadingRadians();
        double absoluteBearing = BotMaster.staticInstance.getHeadingRadians() + e.getBearingRadians();
        this.dX = BotMaster.staticInstance.getX() + e.getDistance() * Math.sin(absoluteBearing);
        this.dY = BotMaster.staticInstance.getY() + e.getDistance() * Math.cos(absoluteBearing);
        this.dVelocity = e.getVelocity();
    }

    public Vec2D getPosition() {
        return new Vec2D(this.dX, this.dY);
    }

    @Override
    public void reset() {
        this.dLastHeading = 0.0;
        this.dEnergy = 0.0;
        this.dBearing = 0.0;
        this.dBearingRad = 0.0;
        this.dHeading = 0.0;
        this.dHeadingRad = 0.0;
        this.dVelocity = 0.0;
    }
}

