/*
 * Decompiled with CFR 0.152.
 */
package jaybot.strategies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jaybot.bots.BaseBot;
import jaybot.intel.Enemy;
import jaybot.intel.EnemyIntel;
import jaybot.strategies.Strategy;
import jaybot.strategies.Tactic;
import jaybot.strategies.TacticAnalyzer;
import jaybot.strategies.TacticMultiController;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class SplitPersonalityStrategy
implements Strategy,
TacticMultiController {
    protected BaseBot myBot;
    protected Map availablePersonalities = new HashMap();
    protected Tactic mode = null;
    protected TacticAnalyzer decisionMaker;
    protected EnemyIntel opponentTracker;

    public void announceStrategy() {
        this.myBot.logImportant(this.getClass().getName() + " is now the current strategy");
    }

    public void setBot(BaseBot gaurdianship, EnemyIntel opponentTracker) {
        this.myBot = gaurdianship;
        this.opponentTracker = opponentTracker;
    }

    public void setPersonalityDecider(TacticAnalyzer decisionMaker) {
        this.decisionMaker = decisionMaker;
    }

    public TacticAnalyzer getPersonalityDecider() {
        return this.decisionMaker;
    }

    protected Tactic ensureMode() {
        if (this.mode == null) {
            this.changeToBestPersonality();
        }
        if (this.mode == null) {
            throw new RuntimeException("Personality could not be selected, critical error!");
        }
        return this.mode;
    }

    public void doStartupAction() {
        ArrayList selectFrom = new ArrayList(this.availablePersonalities.values());
        for (int i = 0; i < selectFrom.size(); ++i) {
            Tactic p = (Tactic)selectFrom.get(i);
            p.setup(this.myBot, this, this.opponentTracker);
        }
        this.ensureMode();
    }

    public void doRunIteration() {
        this.ensureMode().doRunIteration();
    }

    protected void checkModeForPersonalityChange() {
        this.changeToBestPersonality();
    }

    public void reactToBulletHitTarget(BulletHitEvent event, Enemy actualTarget, Enemy intendedTarget) {
        this.ensureMode().reactToBulletHitTarget(event, actualTarget, intendedTarget);
        this.checkModeForPersonalityChange();
    }

    public void reactToBulletHitAnotherBullet(BulletHitBulletEvent event, Enemy ownerOfOtherBullet, Enemy intendedTarget) {
        this.ensureMode().reactToBulletHitAnotherBullet(event, ownerOfOtherBullet, intendedTarget);
        this.checkModeForPersonalityChange();
    }

    public void reactToBulletMissedTarget(BulletMissedEvent event, Enemy intendedTarget) {
        this.ensureMode().reactToBulletMissedTarget(event, intendedTarget);
        this.checkModeForPersonalityChange();
    }

    public void reactToYourDeath(DeathEvent event) {
        this.ensureMode().reactToYourDeath(event);
    }

    public void reactToYouHitByEnemyBullet(HitByBulletEvent event, Enemy badGuy) {
        this.ensureMode().reactToYouHitByEnemyBullet(event, badGuy);
        this.checkModeForPersonalityChange();
    }

    public void reactToYouCollidedWithEnemyRobot(HitRobotEvent event, Enemy badGuy) {
        this.ensureMode().reactToYouCollidedWithEnemyRobot(event, badGuy);
        this.checkModeForPersonalityChange();
    }

    public void reactToYouHitWall(HitWallEvent event) {
        this.ensureMode().reactToYouHitWall(event);
        this.checkModeForPersonalityChange();
    }

    public void reactToAnotherRobotDeath(RobotDeathEvent event, Enemy deadBadGuy) {
        this.ensureMode().reactToAnotherRobotDeath(event, deadBadGuy);
        this.checkModeForPersonalityChange();
    }

    public void reactToSeeingEnemyRobot(ScannedRobotEvent event, Enemy badGuy) {
        this.ensureMode().reactToSeeingEnemyRobot(event, badGuy);
        this.checkModeForPersonalityChange();
    }

    public void reactToYouWinning(WinEvent event) {
        this.myBot.logImportant("*** I win! *** ");
        this.ensureMode().reactToYouWinning(event);
        this.myBot.turnRight(90.0);
        this.myBot.turnLeft(90.0);
        this.myBot.turnRight(180.0);
        this.myBot.turnLeft(-180.0);
        this.myBot.turnRight(360.0);
        this.myBot.turnLeft(-360.0);
        this.myBot.turnRight(720.0);
        this.myBot.turnLeft(-720.0);
    }

    public void reactToGameEnding() {
        this.myBot.logImportant("*** Game over. ***");
        this.ensureMode().reactToGameEnding();
    }

    public Tactic getPersonalityByName(String name) {
        return (Tactic)this.availablePersonalities.get(name);
    }

    public void changeToBestPersonality() {
        if (this.availablePersonalities.size() == 0) {
            throw new RuntimeException("No personalities available for strategy to use!");
        }
        if (this.decisionMaker == null) {
            throw new RuntimeException("Cannot proceed without a Personality decision maker!");
        }
        Tactic newSelection = this.decisionMaker.getBestTactic(this, this, this.availablePersonalities, this.mode);
        if (newSelection == null) {
            if (this.mode == null) {
                throw new RuntimeException("Personality decision maker must decide at least an initial personality, it did not do this duty!");
            }
            return;
        }
        if (this.mode == null || !newSelection.getTacticName().equals(this.mode.getTacticName())) {
            this.myBot.stop(true);
            this.changeToPersonality(newSelection.getTacticName());
        }
    }

    public void addPersonality(Tactic newPersonality) {
        this.availablePersonalities.put(newPersonality.getTacticName(), newPersonality);
    }

    public void changeToPersonality(String selectPersonalityName) {
        Tactic changeTo = this.getPersonalityByName(selectPersonalityName);
        if (changeTo != null) {
            Tactic oldMode = this.mode;
            this.mode = changeTo;
            if (oldMode == null || !this.mode.getTacticName().equals(oldMode.getTacticName())) {
                this.myBot.stop();
                this.mode.setup(this.myBot, this, this.opponentTracker);
                this.mode.announceTactic();
                this.mode.doStartupAction();
            }
        } else {
            throw new RuntimeException("Personality requested cannot be found!  name=" + selectPersonalityName);
        }
    }

    public Tactic getCurrentPersonality() {
        return this.mode;
    }
}

