/*
 * Decompiled with CFR 0.152.
 */
package divineomega;

import divineomega.GFTUtils;
import divineomega.GFTWave;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.util.Utils;

public class PatrollerBot
extends AdvancedRobot {
    final double fullTurnRadians = Math.PI * 2;
    final double distanceFromWall = 20.0;
    double x = 0.0;
    double y = 0.0;
    double battlefieldWidth = 0.0;
    double battlefieldHeight = 0.0;
    String primaryState = "";
    String selectedWall = "";
    private Point2D enemyLocation;
    private double lastEnemyVelocity;
    private String targetting;

    public void run() {
        this.primaryState = "start";
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            this.scan();
        }
    }

    public void onStatus(StatusEvent e) {
        this.x = this.getX();
        this.y = this.getY();
        this.battlefieldWidth = this.getBattleFieldWidth();
        this.battlefieldHeight = this.getBattleFieldHeight();
        if (this.primaryState.equals("start")) {
            this.setAdjustGunForRobotTurn(true);
            this.setAdjustRadarForGunTurn(true);
            this.setAdjustRadarForRobotTurn(true);
            this.primaryState = "go_to_wall";
        }
        if (this.primaryState.equals("go_to_wall")) {
            this.goToNearestWall();
            if (this.x <= 20.0 || this.x >= this.battlefieldWidth - 20.0) {
                this.primaryState = "align_with_enemy";
            }
        }
    }

    private void alignWithEnemy(ScannedRobotEvent e) {
        if (this.getDistanceRemaining() > 0.0) {
            return;
        }
        double moveToX = 0.0;
        double moveToY = 0.0;
        if (this.selectedWall.equals("left")) {
            moveToX = 20.0;
        } else if (this.selectedWall.equals("right")) {
            moveToX = this.battlefieldWidth - 20.0;
        }
        moveToY = this.enemyLocation.getY();
        moveToY -= Math.random() * 80.0;
        if ((moveToY += Math.random() * 80.0) <= 20.0 || moveToY >= this.battlefieldHeight - 20.0) {
            return;
        }
        Point2D.Double newLocation = new Point2D.Double(moveToX, moveToY);
        if (newLocation.distance(this.enemyLocation) <= 100.0) {
            return;
        }
        this.goTo(newLocation);
    }

    private void alignGunAndFire(ScannedRobotEvent e) {
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double bulletPower = 3.0;
        double gunTurn = 0.0;
        if (this.targetting == null) {
            this.targetting = "guess_factor";
        }
        if (this.targetting.equals("guess_factor")) {
            gunTurn = this.getGFGunTurn(e, bulletPower);
        } else if (this.targetting.equals("random")) {
            bulletPower = 0.1;
            double escapeAngle = Math.asin(8.0 / Rules.getBulletSpeed((double)bulletPower));
            double randomAimOffset = -escapeAngle + Math.random() * 2.0 * escapeAngle;
            double headOnTargeting = absoluteBearing - this.getGunHeadingRadians();
            gunTurn = headOnTargeting + randomAimOffset;
        }
        gunTurn = Utils.normalRelativeAngle((double)gunTurn);
        this.setTurnGunRightRadians(gunTurn);
        if (this.getGunTurnRemainingRadians() <= 0.06283185307179587 && this.getGunHeat() == 0.0) {
            this.setFire(bulletPower);
            if (this.targetting.equals("guess_factor")) {
                this.targetting = "random";
            } else if (this.targetting.equals("random")) {
                this.targetting = "guess_factor";
            }
        }
    }

    private double getGFGunTurn(ScannedRobotEvent e, double bulletPower) {
        String enemyName = e.getName();
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyVelocity = e.getVelocity();
        double enemyHeading = e.getHeadingRadians();
        double enemyDistance = e.getDistance();
        double lateralDirection = 0.0;
        double gunTurn = 0.0;
        Point2D.Double myLocation = new Point2D.Double(this.x, this.y);
        if (enemyVelocity != 0.0) {
            lateralDirection = GFTUtils.sign(enemyVelocity * Math.sin(enemyHeading - absoluteBearing));
        }
        GFTWave wave = new GFTWave(this);
        wave.gunLocation = myLocation;
        GFTWave.targetLocation = GFTUtils.project(wave.gunLocation, absoluteBearing, enemyDistance);
        wave.lateralDirection = lateralDirection;
        wave.bulletPower = bulletPower;
        wave.setSegmentations(enemyName, enemyDistance, enemyVelocity, this.lastEnemyVelocity);
        wave.bearing = absoluteBearing;
        gunTurn = absoluteBearing - this.getGunHeadingRadians() + wave.mostVisitedBearingOffset();
        if (this.getEnergy() >= bulletPower) {
            this.addCustomEvent(wave);
        }
        return gunTurn;
    }

    private Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    private void goToNearestWall() {
        if (this.x <= this.battlefieldWidth / 2.0) {
            this.selectedWall = "left";
            this.goTo(new Point2D.Double(20.0, this.y));
        } else if (this.x > this.battlefieldWidth / 2.0) {
            this.selectedWall = "right";
            this.goTo(new Point2D.Double(this.battlefieldWidth - 20.0, this.y));
        }
    }

    public static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public void goTo(Point2D destination) {
        Point2D.Double myLocation = new Point2D.Double(this.x, this.y);
        double distance = myLocation.distance(destination);
        double angle = PatrollerBot.absoluteBearing(myLocation, destination) - this.getHeadingRadians();
        if (Math.abs(angle = Utils.normalRelativeAngle((double)angle)) > 1.5707963267948966) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.setTurnRightRadians(angle);
        if (Math.abs(angle) < 1.5707963267948966) {
            this.setAhead(distance);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.enemyLocation = this.project(new Point2D.Double(this.getX(), this.getY()), absoluteBearing, e.getDistance());
        this.radarTrack(absoluteBearing);
        if (this.primaryState.equals("align_with_enemy")) {
            this.alignWithEnemy(e);
            this.alignGunAndFire(e);
        }
    }

    private void radarTrack(double absoluteBearing) {
        double factor = 2.0;
        double radarTurn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians()));
        this.setTurnRadarRightRadians(factor * radarTurn);
    }
}

