/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy;

import alk.lap.LoudAndProud;
import alk.lap.strategy.BotRecord;
import alk.lap.strategy.ScanRecord;
import alk.lap.utils.DVektor;
import robocode.util.Utils;

public class Move
implements BotRecord {
    public long startTime;
    public long endTime;
    public double vMax;
    public double vAvg;
    public double length;
    public double signV;
    public String botName;
    public DVektor startPos;
    public DVektor endPos;
    public long duration;

    public Move(long startTime, String botName, double v, DVektor startPos) {
        this.startTime = startTime;
        this.botName = botName;
        this.startPos = startPos;
        this.endTime = 0L;
        this.vMax = v;
        this.vAvg = 0.0;
        this.endPos = startPos;
        this.duration = 0L;
        this.signV = this.signum(v);
    }

    public void closeMove(long endTime, DVektor lastPos) {
        this.endTime = endTime;
        this.length += this.endPos.getDistanceTo(lastPos);
        this.endPos = lastPos;
        this.duration = endTime - this.startTime;
        this.vAvg = Utils.isNear((double)this.length, (double)0.0) ? 0.0 : this.length / (double)this.duration;
    }

    public String toString() {
        return "tStart=" + this.startTime + ",tEnd=" + this.endTime + ",dur=" + this.duration + ",name='" + this.botName + "'" + ",vMax=" + LoudAndProud.printStaticDouble(this.vMax) + ",vAvg=" + LoudAndProud.printStaticDouble(this.vAvg) + ",length=" + LoudAndProud.printStaticDouble(this.length) + ",startP=" + this.startPos.toString() + ",endP=" + (this.endPos == null ? "<null>" : this.endPos.toString());
    }

    public String toCSVHead() {
        return "tStart,tEnd,dur,name,vMax,vAvg,length";
    }

    public String toCSV() {
        return this.startTime + "," + this.endTime + "," + this.duration + ",'" + this.botName + "'" + "," + LoudAndProud.printStaticDouble(this.vMax) + "," + LoudAndProud.printStaticDouble(this.vAvg) + "," + LoudAndProud.printStaticDouble(this.length);
    }

    public boolean hasSameDirection(double v) {
        return this.signV == (double)this.signum(v);
    }

    public boolean hasSameHeading(double h) {
        return false;
    }

    public int signum(double d) {
        if (d == 0.0) {
            return 0;
        }
        if (d > 0.0) {
            return 1;
        }
        return -1;
    }

    public boolean isClosed() {
        return this.endTime != 0L;
    }

    public String getBotName() {
        return this.botName;
    }

    public void updateFrom(ScanRecord currentScan) {
        if (Math.abs(currentScan.atomicMove.velocity) > Math.abs(this.vMax)) {
            this.vMax = currentScan.atomicMove.velocity;
        }
        this.length += this.endPos.getDistanceTo(currentScan.pos);
        this.endPos = currentScan.pos;
        this.duration = currentScan.getScanTime() - this.startTime;
    }
}

