/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.targetting;

import alk.lap.LoudAndProud;
import alk.lap.strategy.FireWave;
import alk.lap.strategy.Move;
import alk.lap.strategy.ScanDatabase;
import alk.lap.strategy.TacticalLead;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;
import alk.lap.utils.LapUtils;
import java.awt.Color;

public class MoveRespectingLinT
implements TargetStrategy {
    private static final double BEAM_ANGLE = 4.0;
    public static final String NAME = "Mo-LinT";
    private static final int MOVE_LOOKBACK = 25;
    private static final boolean TALK = true;
    private double fireEnergy = 3.0;
    private int lookBack = 25;
    private String name = "Mo-LinT";
    LoudAndProud proud;

    public String describe() {
        return this.name;
    }

    public TargetStrategy.StrategyType getType() {
        return TargetStrategy.StrategyType.MoveBased;
    }

    public MoveRespectingLinT setName(String name) {
        this.name = name;
        return this;
    }

    public MoveRespectingLinT setLookBack(int lookBack) {
        this.lookBack = lookBack;
        this.setName(String.valueOf(this.describe()) + "-l" + lookBack);
        return this;
    }

    public MoveRespectingLinT setFireEnergy(double fireEnergy) {
        this.fireEnergy = fireEnergy;
        this.setName(String.valueOf(this.describe()) + "-f" + LoudAndProud.printStaticDouble(fireEnergy));
        return this;
    }

    public double[] getFireAngleTo(int target, FireWave wave) {
        double angle = 0.0;
        DVektor targetStartPosAtIteration = null;
        DVektor targetVAtIteration = null;
        DVektor gunnerPosition = null;
        double bearingToTarget = 0.0;
        long iterationTime = 0L;
        double distanceWhole = 0.0;
        if (target == 0) {
            TacticalLead tLead = this.proud.getTacticLead();
            ScanDatabase scanbase = this.proud.getStrategicLead().getAnalystsDB().getScanBase();
            if (!tLead.isEnemySpotted()) {
                return LapUtils.toDArray(this.proud.getRadarHeading());
            }
            boolean found = false;
            targetStartPosAtIteration = tLead.getEnemyPos().copy();
            if (tLead.isEnemySpotted()) {
                Move currentMove = scanbase.getCurrentEnemyMove();
                this.proud.getVc().drawLine(DVektor.add(targetStartPosAtIteration, DVektor.fromPolarCoord(this.proud.getTacticLead().getEnemyHeading() + 180.0, currentMove.signV * currentMove.length)), targetStartPosAtIteration, "moveMade");
                this.proud.getVc().drawLine(DVektor.add(targetStartPosAtIteration, DVektor.fromPolarCoord(this.proud.getTacticLead().getEnemyHeading(), currentMove.signV * this.proud.getStrategicLead().getAnalystsDB().getScanBase().getAverageEnemyMoveLength(this.lookBack) - currentMove.signV * currentMove.length)), targetStartPosAtIteration, "moveToBe");
            }
            gunnerPosition = this.proud.getPosition();
            while (!found) {
                bearingToTarget = gunnerPosition.getDirectionTo(targetStartPosAtIteration);
                targetVAtIteration = this.getVEnemyTarget(iterationTime, distanceWhole, targetStartPosAtIteration);
                double cosAlpha = Math.cos(Math.toRadians(180.0 - (targetVAtIteration.getDirection() - bearingToTarget)));
                double distance = gunnerPosition.getDistanceTo(targetStartPosAtIteration);
                double targetVel = targetVAtIteration.getLength();
                double bulletVel = 20.0 - 3.0 * this.fireEnergy;
                double a = targetVel * targetVel - bulletVel * bulletVel;
                double b = 2.0 * bulletVel * bulletVel * (double)iterationTime + 2.0 * targetVel * distance * cosAlpha;
                double c = distance * distance - Math.pow(bulletVel * (double)iterationTime, 2.0);
                double tD = (b - Math.sqrt(Math.pow(b, 2.0) - 4.0 * a * c)) / (2.0 * a);
                if (tD < 1.0) {
                    found = true;
                    targetStartPosAtIteration.add(DVektor.scaleVector(targetVAtIteration, tD));
                    this.proud.getVc().drawPoint(targetStartPosAtIteration, "pTP1", 1);
                    continue;
                }
                if (iterationTime % 10L == 0L) {
                    this.proud.getVc().drawPoint(targetStartPosAtIteration.copy(), "pTP at " + iterationTime, 1);
                }
                ++iterationTime;
                targetStartPosAtIteration.add(targetVAtIteration);
                distanceWhole += targetVel;
            }
            angle = gunnerPosition.getDirectionTo(targetStartPosAtIteration);
        }
        return LapUtils.toDArray(angle);
    }

    private DVektor getVEnemyTarget(double iterationTime, double distanceWhole, DVektor targetStartPosAtIteration) {
        DVektor tV;
        long avgMoveDur;
        boolean migthHaveTurned = false;
        Double currentV = 8.0;
        if (this.proud.getTacticLead().isEnemySpotted() && (avgMoveDur = this.proud.getStrategicLead().getAnalystsDB().getScanBase().getAverageEnemyMoveDuration(this.lookBack)) != 0L) {
            long numberOfMoves = ((long)iterationTime + this.proud.getStrategicLead().getAnalystsDB().getScanBase().getCurrentEnemyMove().duration) / avgMoveDur;
            long timeInCurrentMove = ((long)iterationTime + this.proud.getStrategicLead().getAnalystsDB().getScanBase().getCurrentEnemyMove().duration) % avgMoveDur;
            if (avgMoveDur > 12L) {
                if (timeInCurrentMove <= 8L) {
                    currentV = timeInCurrentMove;
                }
                if (avgMoveDur - timeInCurrentMove < 4L) {
                    currentV = (double)(avgMoveDur - timeInCurrentMove) * 2.0;
                }
            }
            if (numberOfMoves % 2L == 1L) {
                migthHaveTurned = true;
            }
        }
        double eHeading = this.proud.getTacticLead().getEnemyHeading();
        if (this.proud.getTacticLead().getEnemyVelocitiy() < 0.0) {
            eHeading += 180.0;
        }
        if (migthHaveTurned) {
            eHeading += 180.0;
        }
        if (this.proud.isInBorder(DVektor.add(targetStartPosAtIteration, tV = DVektor.fromPolarCoord(eHeading, currentV)))) {
            return tV;
        }
        return new DVektor(0.0, 0.0);
    }

    public double getFireEnergy() {
        return this.fireEnergy;
    }

    public double getBeamAngle() {
        return 4.0;
    }

    public Color getColorCode() {
        return Color.yellow;
    }

    public void newRound(LoudAndProud proud) {
        this.proud = proud;
    }
}

