/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.mea;

import dsekercioglu.mega.core.wiki.FastMath;
import dsekercioglu.mega.rMove.MoveUtils;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MEA {
    private final double BF_WIDTH;
    private final double BF_HEIGHT;
    private final double ORIENTATION = 0.01;
    private final int MAX_ITERATIONS;
    private final Rectangle2D.Double B_FIELD;
    private Point2D.Double[] escapePositions = new Point2D.Double[2];
    private double[] escapeAngles = new double[2];

    public MEA(double battleFieldWidth, double battleFieldHeight) {
        this.BF_WIDTH = battleFieldWidth;
        this.BF_HEIGHT = battleFieldHeight;
        this.MAX_ITERATIONS = (int)Math.ceil(314.1592653589793);
        this.B_FIELD = new Rectangle2D.Double(17.9, 17.9, battleFieldWidth - 35.8, battleFieldHeight - 35.8);
    }

    public void calculateEscapeAngle(Point2D.Double robotLocation, Point2D.Double orbitLocation, double bulletSpeed) {
        for (int i = -1; i <= 1; i += 2) {
            double absoluteBearing = MoveUtils.absoluteBearing(orbitLocation, robotLocation);
            double moveAngle = absoluteBearing + 1.5707963267948966;
            Point2D.Double interception = MEA.intercept(orbitLocation, bulletSpeed, robotLocation, moveAngle, 8 * i);
            for (int iterations = 0; !this.B_FIELD.contains(interception) && iterations <= this.MAX_ITERATIONS; ++iterations) {
                interception = MEA.intercept(orbitLocation, bulletSpeed, robotLocation, moveAngle += 0.01 * (double)i, 8 * i);
            }
            int index = (i + 1) / 2;
            this.escapePositions[index] = interception;
            this.escapeAngles[index] = MoveUtils.absoluteBearing(orbitLocation, interception);
        }
    }

    public Point2D.Double getEscapePosition(int direction) {
        return this.escapePositions[(direction + 1) / 2];
    }

    public double getEscapeAngle(int direction) {
        return this.escapeAngles[(direction + 1) / 2];
    }

    static Point2D.Double intercept(Point2D pos, double vel, Point2D tPos, double tHeading, double tVel) {
        double tVelX = FastMath.sin(tHeading) * tVel;
        double tVelY = FastMath.cos(tHeading) * tVel;
        double relX = tPos.getX() - pos.getX();
        double relY = tPos.getY() - pos.getY();
        double b = relX * tVelX + relY * tVelY;
        double a = vel * vel - tVel * tVel;
        b = (b + Math.sqrt(b * b + a * (relX * relX + relY * relY))) / a;
        return new Point2D.Double(tVelX * b + tPos.getX(), tVelY * b + tPos.getY());
    }
}

