/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.movetree.nodes.modify.decay;

import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.rMove.info.WaveData;
import dsekercioglu.mega.rMove.movetree.nodes.Node;
import java.util.ArrayList;
import java.util.List;

public class KNNScanNode
extends Node {
    final Node NODE;
    final double DECAY_FACTOR;

    public KNNScanNode(double decayFactor, Node node) {
        this.DECAY_FACTOR = decayFactor;
        this.NODE = node;
    }

    @Override
    public List<GuessFactor> getGuessFactors(WaveData battleInfo) {
        double maxScan = 0.0;
        ArrayList<GuessFactor> weightedGuessFactors = new ArrayList<GuessFactor>();
        List<GuessFactor> guessFactors = this.NODE.getGuessFactors(battleInfo);
        for (GuessFactor guessFactor : guessFactors) {
            if ((double)guessFactor.SCAN > maxScan) {
                maxScan = guessFactor.SCAN;
            }
            weightedGuessFactors.add(new GuessFactor(guessFactor.GUESS_FACTOR, guessFactor.getWeight(), guessFactor.SCAN));
        }
        double ratio = 2.0 / maxScan;
        if (!Double.isFinite(ratio)) {
            ratio = 0.0;
        }
        for (GuessFactor guessFactor : weightedGuessFactors) {
            guessFactor.setWeight(guessFactor.getWeight() * Math.pow(this.DECAY_FACTOR, ((double)guessFactor.SCAN - maxScan) * ratio));
        }
        return weightedGuessFactors;
    }

    @Override
    public void addData(WaveData battleInfo, GuessFactor guessFactor, boolean real) {
        this.NODE.addData(battleInfo, guessFactor, real);
    }

    @Override
    public String toString() {
        return this.getName() + ":(" + this.NODE.toString() + ")";
    }
}

