/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.movetree.nodes.modify.weight;

import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.core.wiki.FastMath;
import dsekercioglu.mega.rMove.info.WaveData;
import dsekercioglu.mega.rMove.movetree.nodes.Node;
import java.util.List;

public class AreaNormNode
extends Node {
    private final Node NODE;
    private final double SMOOTH_FACTOR;
    private final double MAX_VALUE;

    public AreaNormNode(Node node, double bandwidth) {
        this.NODE = node;
        this.SMOOTH_FACTOR = bandwidth;
        this.MAX_VALUE = 1.0 / (this.integrateDanger(1.0, 1.0, this.SMOOTH_FACTOR) - this.integrateDanger(-1.0, 1.0, this.SMOOTH_FACTOR));
    }

    @Override
    public List<GuessFactor> getGuessFactors(WaveData battleInfo) {
        List<GuessFactor> guessFactors = this.NODE.getGuessFactors(battleInfo);
        double area = 0.0;
        for (GuessFactor guessFactor : guessFactors) {
            area += this.integrateDanger(1.0 - guessFactor.GUESS_FACTOR, guessFactor.getWeight(), this.SMOOTH_FACTOR) - this.integrateDanger(-1.0 - guessFactor.GUESS_FACTOR, guessFactor.getWeight(), this.SMOOTH_FACTOR);
        }
        area /= this.MAX_VALUE;
        for (GuessFactor guessFactor : guessFactors) {
            guessFactor.setWeight(guessFactor.getWeight() / area);
        }
        return guessFactors;
    }

    @Override
    public void addData(WaveData battleInfo, GuessFactor guessFactor, boolean real) {
        this.NODE.addData(battleInfo, guessFactor, real);
    }

    @Override
    public String toString() {
        return this.getName() + ":(" + this.NODE.toString() + ")";
    }

    private double integrateDanger(double value, double weight, double smoothFactor) {
        return smoothFactor * weight * FastMath.atan(value / smoothFactor);
    }
}

