/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.movetree.nodes.modify.weight;

import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.rMove.info.WaveData;
import dsekercioglu.mega.rMove.movetree.nodes.Node;
import java.util.ArrayList;
import java.util.List;

public class WeightedNode
extends Node {
    final double[] WEIGHTS;
    final Node[] NODES;

    public WeightedNode(double[] weights, Node ... nodes) {
        this.WEIGHTS = weights;
        this.NODES = nodes;
    }

    @Override
    public List<GuessFactor> getGuessFactors(WaveData battleInfo) {
        ArrayList<GuessFactor> weightedGuessFactors = new ArrayList<GuessFactor>();
        for (int i = 0; i < this.WEIGHTS.length; ++i) {
            Node node = this.NODES[i];
            List<GuessFactor> ithGuessFactors = node.getGuessFactors(battleInfo);
            for (GuessFactor guessFactor : ithGuessFactors) {
                weightedGuessFactors.add(new GuessFactor(guessFactor.GUESS_FACTOR, this.WEIGHTS[i] * guessFactor.getWeight(), guessFactor.SCAN));
            }
        }
        return weightedGuessFactors;
    }

    @Override
    public void addData(WaveData battleInfo, GuessFactor guessFactor, boolean real) {
        for (Node node : this.NODES) {
            node.addData(battleInfo, guessFactor, real);
        }
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder("\n");
        for (int i = 0; i < this.WEIGHTS.length; ++i) {
            out.append(this.NODES[i].toString()).append(": ").append(this.WEIGHTS[i]).append("\n");
        }
        return out.toString();
    }
}

