/*
 * Decompiled with CFR 0.152.
 */
package rz.a;

import java.util.ArrayList;
import java.util.Iterator;
import rz.a.AbstractRobot;
import rz.a.Enemy;
import rz.a.Wave;

public class Statistics {
    private static AbstractRobot ar;
    public static final int HIT_FACTOR = 12;
    public static final int BULLET_POWER = 3;
    public static final int ACCELERATION_INDEXES = 3;
    public static final int VELOCITY_INDEXES = 3;
    public static final int DISTANCE_INDEXES = 7;
    public static final int GF_ZERO = 17;
    public static final int AIM_FACTORS = 35;
    public static final int NR_TO_ACTIVATE_DISTANCE = 10;
    public static final int NR_TO_ACTIVATE_REST = 30;
    public int numberOfShots;
    public int numberOfHits;
    public int bearingDirection;
    public boolean segmentationDist;
    public boolean segmentationTot;
    public double[][][][][] hitFactors;
    public double[][][][][] flatFactors;
    public boolean[][][][] hitDistribution;
    public ArrayList eWaves;

    public void initNewRound() {
        int k;
        int j;
        int i;
        this.eWaves = new ArrayList();
        if (!this.segmentationDist && this.numberOfHits > 10) {
            int j2 = 0;
            while (j2 < 7) {
                System.arraycopy(this.hitFactors[0][0][0][0], 0, this.hitFactors[0][0][0][j2], 0, 35);
                System.arraycopy(this.flatFactors[0][0][0][0], 0, this.flatFactors[0][0][0][j2], 0, 35);
                ++j2;
            }
            this.segmentationDist = true;
        }
        if (!this.segmentationTot && this.numberOfHits > 30) {
            i = 0;
            while (i < 3) {
                j = 0;
                while (j < 3) {
                    k = 0;
                    while (k < 3) {
                        System.arraycopy(this.hitFactors[0][0][0], 0, this.hitFactors[i][j][k], 0, 7);
                        System.arraycopy(this.flatFactors[0][0][0], 0, this.flatFactors[i][j][k], 0, 7);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            this.segmentationTot = true;
        }
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                k = 0;
                while (k < 3) {
                    int l = 0;
                    while (l < 7) {
                        boolean[] blArray = this.hitDistribution[i][j][k];
                        boolean bl = false;
                        if (this.getDistribution(this.hitFactors[i][j][k][l], 7) > 0.8) {
                            bl = true;
                        }
                        blArray[l] = bl;
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public double getSum(double[] a) {
        double sum = 0.0;
        int i = 0;
        while (i < 35) {
            sum += a[i];
            ++i;
        }
        return sum;
    }

    public double getDistribution(double[] a, int nomberOfEntries) {
        double[] array = new double[a.length];
        System.arraycopy(a, 0, array, 0, a.length);
        double sum = 0.0;
        int i = 0;
        while (i < 35) {
            int j = i + 1;
            while (j < 35) {
                if (array[j] > array[i]) {
                    double dummy = array[i];
                    array[i] = array[j];
                    array[j] = dummy;
                }
                ++j;
            }
            sum += array[i];
            ++i;
        }
        if (sum == 0.0) {
            return 1.0;
        }
        double sumPart = 0.0;
        int i2 = 0;
        while (i2 < nomberOfEntries) {
            sumPart += array[i2];
            ++i2;
        }
        return sumPart / sum;
    }

    public void updateWaves() {
        Iterator iterator = this.eWaves.iterator();
        while (iterator.hasNext()) {
            Wave wave = (Wave)iterator.next();
            if (!wave.passed && wave.testHit(AbstractRobot.myPos, ar.getTime())) {
                wave.updateStats(ar, wave.flatFactors, wave.gunLocation.bearingTo(AbstractRobot.myPos), (int)this.getSum(wave.flatFactors));
                wave.passed = true;
            }
            if (!wave.testFar(AbstractRobot.myPos, ar.getTime())) continue;
            iterator.remove();
        }
    }

    public void hitByBullet(double bulletHeading, double firePower) {
        Wave wave = this.getClosestWave(true);
        if (wave != null) {
            wave.updateStats(ar, wave.hitFactors, wave.gunLocation.bearingTo(AbstractRobot.myPos), 12);
            ++this.numberOfHits;
        }
    }

    public void scanUpdate(Enemy enemy) {
        double bearingToMe = enemy.lastPos.bearingTo(AbstractRobot.myLastPos);
        double myLatVel = AbstractRobot.lastVelocity * Math.sin(AbstractRobot.lastHeading - bearingToMe);
        if (Math.abs(myLatVel) > 0.01) {
            this.bearingDirection = myLatVel > 0.0 ? 1 : -1;
        } else if (this.bearingDirection == 0) {
            this.bearingDirection = 1;
        }
        if (enemy.justFired) {
            ++this.numberOfShots;
            double waveBearingDirection = (double)this.bearingDirection * Math.asin(8.0 / enemy.fireSpeed) / 15.0;
            int pow = this.powerIndex(enemy.fireSpeed);
            int acc = this.accelerationIndex();
            int vel = this.velocityIndex();
            int dis = this.distanceIndex();
            this.eWaves.add(new Wave(enemy.lastPos, bearingToMe, enemy.fireSpeed, waveBearingDirection, ar.getTime() - (long)2, this.hitFactors[pow][acc][vel][dis], this.flatFactors[pow][acc][vel][dis], this.hitDistribution[pow][acc][vel][dis]));
        }
    }

    public Wave getClosestWave(boolean dontCheckPassed) {
        Wave closestWave = null;
        double minDiff = Double.POSITIVE_INFINITY;
        double myX = ar.getX();
        double myY = ar.getY();
        if (this.eWaves != null) {
            Iterator iterator = this.eWaves.iterator();
            while (iterator.hasNext()) {
                Wave wave = (Wave)iterator.next();
                double momDiff = Math.abs(wave.travel(ar.getTime()) - wave.gunLocation.distance(myX, myY)) / wave.bulletVelocity;
                if (!dontCheckPassed && wave.passed || !(momDiff < minDiff)) continue;
                minDiff = momDiff;
                closestWave = wave;
            }
        }
        return closestWave;
    }

    public int powerIndex(double speed) {
        if (this.segmentationTot) {
            return (int)AbstractRobot.limit(0.0, (20.0 - speed) / (double)3 + 0.1, 2.99);
        }
        return 0;
    }

    public int accelerationIndex() {
        if (this.segmentationTot) {
            int accel = (int)Math.round(AbstractRobot.lastAcceleration);
            if (accel != 0) {
                int n = 0;
                if (accel < 0) {
                    n = 1;
                }
                accel = 2 - n;
            }
            return accel;
        }
        return 0;
    }

    public int velocityIndex() {
        if (this.segmentationTot) {
            double v = AbstractRobot.lastVelocity * Math.sin(AbstractRobot.lastHeading - AbstractRobot.target.lastPos.bearingTo(AbstractRobot.myLastPos));
            return (int)(Math.abs(v) / (double)3);
        }
        return 0;
    }

    public int distanceIndex() {
        if (this.segmentationDist) {
            return Math.min(6, (int)(AbstractRobot.target.lastPos.distance(AbstractRobot.myLastPos) / 8.0 / AbstractRobot.target.fireSpeed));
        }
        return 0;
    }

    public Statistics(AbstractRobot ar) {
        Statistics.ar = ar;
        this.hitFactors = new double[3][3][3][7][35];
        this.flatFactors = new double[3][3][3][7][35];
        this.hitDistribution = new boolean[3][3][3][7];
        this.numberOfShots = 0;
        this.numberOfHits = 0;
        this.segmentationDist = false;
        this.segmentationTot = false;
    }
}

