/*
 * Decompiled with CFR 0.152.
 */
package suzushin7.nano;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class TargetC
extends AdvancedRobot {
    public static final double BULLET_POWER = 3.0;
    private static double lastEnemyHeading;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            if (this.getRadarTurnRemaining() == 0.0) {
                this.setTurnRadarRight(360.0);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())));
        double predictedX = this.getX() + e.getDistance() * Math.sin(absBearing);
        double predictedY = this.getY() + e.getDistance() * Math.cos(absBearing);
        double enemyHeading = e.getHeadingRadians();
        double enemyHeadingChange = e.getHeadingRadians() - lastEnemyHeading;
        double dt = 0.0;
        while (true) {
            double d;
            dt += 1.0;
            if (!(Rules.getBulletSpeed((double)3.0) * d < Point2D.distance(this.getX(), this.getY(), predictedX, predictedY))) break;
            predictedX += e.getVelocity() * Math.sin(enemyHeading);
            predictedY += e.getVelocity() * Math.cos(enemyHeading);
            enemyHeading += enemyHeadingChange;
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(predictedX - this.getX(), predictedY - this.getY()) - this.getGunHeadingRadians())));
        this.setFire(3.0);
        lastEnemyHeading = e.getHeadingRadians();
    }
}

