/*
 * Decompiled with CFR 0.152.
 */
package bjl;

import bjl.BattleField;
import bjl.Enemy;
import bjl.EnemyList;
import bjl.FireDemand;
import bjl.Point;
import bjl.Utils;
import bjl.fire.FireStrategy;
import java.util.Enumeration;
import java.util.Vector;

public class FireStrategyManager {
    private Vector strategies;
    private Enemy enemy;

    public void addStrategy(FireStrategy s) {
        this.strategies.add(s);
    }

    public void info(String strategy, boolean hit) {
        Enumeration e = this.strategies.elements();
        while (e.hasMoreElements()) {
            FireStrategy fs = (FireStrategy)e.nextElement();
            if (!strategy.equals(fs.toString())) continue;
            fs.fired();
            if (hit) {
                fs.hit(this.enemy.getName());
                continue;
            }
            fs.miss();
        }
    }

    public void reInit() {
        Enumeration e = this.strategies.elements();
        while (e.hasMoreElements()) {
            FireStrategy fs = (FireStrategy)e.nextElement();
            fs.reInit();
        }
    }

    public void doTick() {
        Enumeration e = this.strategies.elements();
        while (e.hasMoreElements()) {
            ((FireStrategy)e.nextElement()).doTick();
        }
    }

    public void doFire(double power) {
        Enumeration e = this.strategies.elements();
        while (e.hasMoreElements()) {
            ((FireStrategy)e.nextElement()).doFire(power);
        }
    }

    public FireDemand getFireDemand(Enemy enemy) {
        Point myPos = BattleField.getPos();
        FireDemand ans = new FireDemand(0.0, -1.0, myPos.angleTo(enemy.getLastPosition()), myPos.dist(enemy.getLastPosition()), null);
        Enumeration e = this.strategies.elements();
        while (e.hasMoreElements()) {
            FireStrategy s = (FireStrategy)e.nextElement();
            FireDemand temp = s.doVirtual();
            temp.prob += Math.random() * 0.07;
            if (!(temp.prob > ans.prob)) continue;
            ans = temp;
        }
        double targetAngle = ans.bearing;
        double mateAngle = 0.0;
        double allow = 0.0;
        e = EnemyList.getHashElements();
        while (e.hasMoreElements()) {
            Enemy temp2 = (Enemy)e.nextElement();
            if (!temp2.isTeammate() || temp2.isDead() || temp2.isMe() || temp2.getLastPosition().dist(myPos) > Math.max(enemy.getLastPosition().dist(myPos), 55.0)) continue;
            mateAngle = myPos.angleTo(temp2.getLastPosition());
            allow = Utils.normalHeading(Math.toDegrees(Math.asin(30.0 / temp2.getLastPosition().dist(myPos))));
            if (!(Math.abs(Utils.normalRelativeAngle(mateAngle - targetAngle)) < allow)) continue;
            ans.power = 0.0;
        }
        if (enemy.getLastBlip().time < BattleField.getTime() - 20L) {
            ans.power = 0.0;
        }
        return ans;
    }

    public void dumpStats() {
        BattleField.println("Stats for " + this.enemy + ':');
        Enumeration e = this.strategies.elements();
        while (e.hasMoreElements()) {
            BattleField.println("  " + ((FireStrategy)e.nextElement()).stats());
        }
    }

    public FireStrategyManager(Enemy e) {
        this.enemy = e;
        this.strategies = new Vector();
    }
}

