/*
 * Decompiled with CFR 0.152.
 */
package bjl;

import bjl.Blip;
import bjl.Enemy;
import bjl.PatternBlip;
import bjl.Point;

public class Pattern {
    private int stRoundNum;
    private long stTime;
    private int length;
    private Enemy enemy;
    private int repeats;

    public Point getPosition(int startTime, int time, Blip start) {
        if (startTime < 0 || startTime > this.length || time < startTime || time > this.length) {
            return null;
        }
        Point them = new Point(start.pos);
        double deltaTime = 0.0;
        Blip b = new Blip(start);
        int i = startTime;
        while (i < time) {
            deltaTime += 1.0;
            PatternBlip p = this.enemy.getPBlip((long)i + this.stTime, this.stRoundNum);
            if (p == null) {
                them.x += Math.sin(Math.toRadians(b.head)) * b.vel;
                them.y += Math.cos(Math.toRadians(b.head)) * b.vel;
            } else {
                int j = 0;
                while ((double)j < deltaTime) {
                    b.head += p.turnRate;
                    b.pos.x += Math.sin(Math.toRadians(b.head)) * p.vel;
                    b.pos.y += Math.cos(Math.toRadians(b.head)) * p.vel;
                    ++j;
                }
                b.vel = p.vel;
                them = new Point(b.pos);
                deltaTime = 0.0;
            }
            ++i;
        }
        return them;
    }

    public PatternBlip getPBlip(long deltaT) {
        return this.enemy.getPBlip(deltaT + this.stTime, this.stRoundNum);
    }

    public int getRoundNum() {
        return this.stRoundNum;
    }

    public long getTime() {
        return this.stTime;
    }

    public int getLength() {
        return this.length;
    }

    public Enemy getEnemy() {
        return this.enemy;
    }

    public void incRepeats() {
        ++this.repeats;
    }

    public int getRepeats() {
        return this.repeats;
    }

    public Pattern(int rN, long t, int l, Enemy e, int r) {
        this.stRoundNum = rN;
        this.stTime = t;
        this.length = l;
        this.enemy = e;
        this.repeats = r;
    }

    public Pattern(Pattern p) {
        this.stRoundNum = p.getRoundNum();
        this.stTime = p.getTime();
        this.length = p.getLength();
        this.enemy = p.getEnemy();
        this.repeats = p.getRepeats();
    }
}

