/*
 * Decompiled with CFR 0.152.
 */
package bjl.move;

import bjl.AvoidPoint;
import bjl.BattleField;
import bjl.EnemyList;
import bjl.MoveDemand;
import bjl.Point;
import bjl.SuperBlip;
import bjl.Utils;
import bjl.move.MoveStrategy;
import java.util.Enumeration;

public class BulletDodge
extends MoveStrategy {
    Point random = null;
    long rTime = 0L;

    public void reInit() {
        super.reInit();
        this.rTime = 0L;
        this.random = null;
    }

    public MoveDemand getMoveDemand(boolean isCurStrategy, int type) {
        double dist;
        MoveDemand ans;
        SuperBlip me = BattleField.getMe();
        if (this.random == null && Math.random() < 0.2) {
            this.rTime = BattleField.getTime();
            this.random = new Point(me.pos);
        }
        if (this.rTime < BattleField.getTime() - 10L) {
            this.random = null;
        }
        if ((ans = super.getMoveDemand(true, type)) != null) {
            return ans;
        }
        ans = new MoveDemand(0.0, 0.0, true, true, 0.0, 0.0, this);
        if (!isCurStrategy) {
            ans.setAhead = true;
        }
        Point dir = new Point(0.0, 0.0);
        Point pos = me.pos;
        double width = BattleField.getWidth();
        double height = BattleField.getHeight();
        ans.maxSpeed = 2;
        Enumeration e = EnemyList.avoidPoints.elements();
        while (e.hasMoreElements()) {
            AvoidPoint temp = (AvoidPoint)e.nextElement();
            if (temp.type == 2 || !((dist = temp.dist(BattleField.getPos())) < 100.0) || temp.time - BattleField.getTime() >= 17L) continue;
            if (dist < 1.0) {
                if (pos.x < 120.0) {
                    temp.x -= (double)2;
                } else if (pos.x > width - 120.0) {
                    temp.x += (double)2;
                }
                if (pos.y < 120.0) {
                    temp.y -= (double)2;
                } else if (pos.y > height - 120.0) {
                    temp.y += (double)2;
                }
                dist = temp.dist(BattleField.getPos());
                while (dist < 1.0) {
                    temp.x += (double)2 * (Math.random() - 0.5);
                    temp.y += (double)2 * (Math.random() - 0.5);
                    dist = temp.dist(BattleField.getPos());
                }
            }
            dir.x += (pos.x - temp.x) / dist;
            dir.y += (pos.y - temp.y) / dist;
            if (!(dist < 70.0)) continue;
            ans.maxSpeed = 8.0;
        }
        if (this.random != null && (dist = this.random.dist(BattleField.getPos())) < 100.0) {
            if (dist < 1.0) {
                if (pos.x < 120.0) {
                    this.random.x -= (double)2;
                } else if (pos.x > width - 120.0) {
                    this.random.x += (double)2;
                }
                if (pos.y < 120.0) {
                    this.random.y -= (double)2;
                } else if (pos.y > height - 120.0) {
                    this.random.y += (double)2;
                }
                dist = this.random.dist(BattleField.getPos());
                while (dist < 1.0) {
                    this.random.x += (double)2 * (Math.random() - 0.5);
                    this.random.y += (double)2 * (Math.random() - 0.5);
                    dist = this.random.dist(BattleField.getPos());
                }
            }
            dir.x += (pos.x - this.random.x) / dist;
            dir.y += (pos.y - this.random.y) / dist;
            ans.maxSpeed = 8.0;
        }
        if (pos.x < 40.0) {
            dir.x += (double)2;
        } else if (pos.x > BattleField.getWidth() - 40.0) {
            dir.x -= (double)2;
        }
        if (pos.y < 40.0) {
            dir.y += (double)2;
        } else if (pos.y > BattleField.getHeight() - 40.0) {
            dir.y -= (double)2;
        }
        ans.ahead = dir.x == 0.0 && dir.y == 0.0 ? 0.0 : (Math.abs(Utils.normalRelativeAngle(new Point(0.0, 0.0).angleTo(dir) - me.head)) < 90.0 ? 20.0 : -20.0);
        boolean bl = false;
        if (me.distRemain < 15.0) {
            bl = true;
        }
        if (this.target != null) {
            double angle = ans.ahead == 0.0 ? 90.0 : (ans.ahead > 0.0 ? Math.max(60.0, Math.min(120.0, 90.0 * Math.exp((200.0 - me.pos.dist(this.target.getLastPosition())) / 200.0))) : 180.0 - Math.max(60.0, Math.min(120.0, 90.0 * Math.exp((200.0 - me.pos.dist(this.target.getLastPosition())) / 200.0))));
            ans.right = Utils.normalRelativeAngle(angle + me.pos.angleTo(this.target.getLastPosition()) - me.head);
        } else {
            ans.right = 0.0;
        }
        return ans;
    }

    public double getUsefulness(int type) {
        if (EnemyList.getNumOpponents() == 1 && this.target != null) {
            return 6.0 + this.randomNumber;
        }
        return -99999.0;
    }

    public boolean isInGroup(String group) {
        if (group.equals("AvoidLinear")) {
            return true;
        }
        if (group.equals("AvoidCircular")) {
            return true;
        }
        if (group.equals("FollowRobot")) {
            return true;
        }
        return group.equals("BulletDodge");
    }

    public String toString() {
        return "BulletDodge";
    }
}

