/*
 * Decompiled with CFR 0.152.
 */
package bjl.target;

import bjl.BattleField;
import bjl.Enemy;
import bjl.EnemyList;
import bjl.Point;
import bjl.target.TargetStrategy;
import java.util.Enumeration;
import java.util.Vector;

public class Cluster
extends TargetStrategy {
    private Enemy[] use;

    private final double getDepth(Point p) {
        double depth = 0.0;
        int i = 0;
        while (i < this.use.length) {
            depth -= Math.exp(-p.dist2(this.use[i].getLastPosition()) / 10000.0);
            ++i;
        }
        return depth;
    }

    private final Point getGrad(Point p) {
        Point grad = new Point(0.0, 0.0);
        int i = 0;
        while (i < this.use.length) {
            Point hisPos = this.use[i].getLastPosition();
            double x = (hisPos.x - p.x) / 100.0;
            double y = (hisPos.y - p.y) / 100.0;
            grad.x += (double)2 * x * Math.exp(-p.dist2(hisPos) / 10000.0);
            grad.y += (double)2 * y * Math.exp(-p.dist2(hisPos) / 10000.0);
            ++i;
        }
        return grad;
    }

    public Enemy getTarget(Enemy curTarget, boolean leader) {
        Point zero = new Point(0.0, 0.0);
        Point minDepthPt = new Point(0.0, 0.0);
        double minDepth = 100000.0;
        Vector<Enemy> toUse = new Vector<Enemy>();
        Enumeration e = EnemyList.getHashElements();
        Point myPos = BattleField.getPos();
        while (e.hasMoreElements()) {
            Enemy en = (Enemy)e.nextElement();
            if (en.isTeammate() || en.isDead() || en.getLastPosition().dist(myPos) > 700.0) continue;
            toUse.add(en);
        }
        this.use = new Enemy[toUse.size()];
        int i = 0;
        while (i < toUse.size()) {
            this.use[i] = (Enemy)toUse.elementAt(i);
            ++i;
        }
        i = 0;
        while (i < this.use.length) {
            Point p;
            Point p2 = new Point(this.use[i].getLastPosition());
            do {
                p = this.getGrad(p2);
                p2.x += p.x * 10.0;
                p2.y += p.y * 10.0;
            } while (zero.dist2(p) > 0.0025);
            double d = this.getDepth(p2);
            if (d < minDepth) {
                minDepthPt = p2;
                minDepth = d;
            }
            ++i;
        }
        if (minDepth < -1.7) {
            BattleField.setTargetPoint(minDepthPt);
        } else {
            BattleField.setTargetPoint(null);
        }
        return null;
    }

    public double getUsefulness(Enemy curTarget, boolean leader) {
        return 0.0;
    }

    public boolean isInGroup(String group) {
        return false;
    }
}

