/*
 * Decompiled with CFR 0.152.
 */
package Polkwane;

import Polkwane.GFTUtils;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

class GFTMovement {
    private static final double BATTLE_FIELD_WIDTH = 800.0;
    private static final double BATTLE_FIELD_HEIGHT = 600.0;
    private static final double WALL_MARGIN = 18.0;
    private static final double MAX_TRIES = 125.0;
    private static final double REVERSE_TUNER = 0.421075;
    private static final double DEFAULT_EVASION = 1.2;
    private static final double WALL_BOUNCE_TUNER = 0.699484;
    private AdvancedRobot robot;
    private Rectangle2D fieldRectangle = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    private double enemyFirePower = 3.0;
    private double direction = 0.4;

    GFTMovement(AdvancedRobot _robot) {
        this.robot = _robot;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Point2D robotDestination;
        double enemyAbsoluteBearing = this.robot.getHeadingRadians() + e.getBearingRadians();
        double enemyDistance = e.getDistance();
        Point2D.Double robotLocation = new Point2D.Double(this.robot.getX(), this.robot.getY());
        Point2D enemyLocation = GFTUtils.project(robotLocation, enemyAbsoluteBearing, enemyDistance);
        double tries = 0.0;
        while (!this.fieldRectangle.contains(robotDestination = GFTUtils.project(enemyLocation, enemyAbsoluteBearing + Math.PI + this.direction, enemyDistance * (1.2 - tries / 100.0))) && tries < 125.0) {
            tries += 1.0;
        }
        if (Math.random() < GFTUtils.bulletVelocity(this.enemyFirePower) / 0.421075 / enemyDistance || tries > enemyDistance / GFTUtils.bulletVelocity(this.enemyFirePower) / 0.699484) {
            this.direction = -this.direction;
        }
        double angle = GFTUtils.absoluteBearing(robotLocation, robotDestination) - this.robot.getHeadingRadians();
        this.robot.setAhead(Math.cos(angle) * 100.0);
        this.robot.setTurnRightRadians(Math.tan(angle));
    }
}

