/*
 * Decompiled with CFR 0.152.
 */
package Polkwane;

import Polkwane.GFTMovement;
import Polkwane.GFTUtils;
import Polkwane.GFTWave;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Intensive
extends AdvancedRobot {
    private static final double BULLET_POWER = 1.9;
    private static double lateralDirection;
    private static double lastEnemyVelocity;
    private static GFTMovement movement;

    public Intensive() {
        movement = new GFTMovement(this);
    }

    public void run() {
        this.setColors(Color.BLUE, Color.BLACK, Color.YELLOW);
        lateralDirection = 1.0;
        lastEnemyVelocity = 0.0;
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyDistance = e.getDistance();
        double enemyVelocity = e.getVelocity();
        if (enemyVelocity != 0.0) {
            lateralDirection = GFTUtils.sign(enemyVelocity * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing));
        }
        GFTWave wave = new GFTWave(this);
        wave.gunLocation = new Point2D.Double(this.getX(), this.getY());
        GFTWave.targetLocation = GFTUtils.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance);
        wave.lateralDirection = lateralDirection;
        wave.bulletPower = 1.9;
        wave.setSegmentations(enemyDistance, enemyVelocity, lastEnemyVelocity);
        lastEnemyVelocity = enemyVelocity;
        wave.bearing = enemyAbsoluteBearing;
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getGunHeadingRadians() + wave.mostVisitedBearingOffset())));
        this.setFire(wave.bulletPower);
        if (this.getEnergy() >= 1.9) {
            this.addCustomEvent(wave);
        }
        movement.onScannedRobot(e);
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getRadarHeadingRadians())) * 2.0);
    }
}

