/*
 * Decompiled with CFR 0.152.
 */
package ola;

import java.io.PrintStream;
import ola.Coordinate;
import ola.Direction;
import ola.MovingObject;
import robocode.Rules;

public class TrigonomyAimer {
    private PrintStream out;

    public TrigonomyAimer() {
    }

    public TrigonomyAimer(PrintStream out) {
        this.out = out;
    }

    public Direction aim(MovingObject target, long currentTime, MovingObject from, double power) {
        double bulletSpeed = Rules.getBulletSpeed((double)power);
        return this.aimAt(target, currentTime, from, bulletSpeed);
    }

    public Direction aimAt(MovingObject target, long currentTime, MovingObject from, double bulletSpeed) {
        Coordinate currentTargetPos = target.getExpectedPossision(currentTime);
        Coordinate currentFromPos = from.getExpectedPossision(currentTime);
        Direction currentDirectionTotarget = currentFromPos.directionTo(currentTargetPos);
        double diff = target.getDirection().difference(currentDirectionTotarget);
        double normDiff = this.rest(diff, 360);
        double absDiff = Math.abs(normDiff);
        double beta = 180.0 - absDiff;
        double alphaRad = Math.asin(target.getVelocity() / bulletSpeed * Math.sin(Math.toRadians(beta)));
        double alpha = Math.toDegrees(alphaRad);
        double signedAlpha = Math.copySign(alpha, normDiff);
        Direction aimAt = currentDirectionTotarget.turn(signedAlpha);
        this.logLine();
        this.logValue("currentTargetPos         ", currentTargetPos);
        this.logValue("currentFromPos           ", currentFromPos);
        this.logValue("currentDirectionTotarget ", currentDirectionTotarget);
        this.logValue("target.getVelocity()     ", target.getVelocity());
        this.logValue("target.getDirection()    ", target.getDirection());
        this.logValue("bulletSpeed              ", bulletSpeed);
        this.logValue("aimAt                    ", aimAt);
        return aimAt;
    }

    private double rest(double d, int div) {
        double k = d / (double)div;
        long l = Math.round(k);
        double r = d - (double)(l * (long)div);
        return r;
    }

    private void logLine() {
        if (this.out != null) {
            this.out.printf("---------------------%n", new Object[0]);
        }
    }

    private void logValue(String name, Object value) {
        if (this.out != null) {
            this.out.printf("%s : %s%n", name, value);
        }
    }
}

