/*
 * Decompiled with CFR 0.152.
 */
package rsalesc.roborio.utils.geo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import rsalesc.roborio.utils.colors.Gradient;
import rsalesc.roborio.utils.geo.Point;

public class G {
    private static final Gradient DANGER_GRADIENT = new Gradient(new Gradient.GradientColor[]{new Gradient.GradientColor(Color.WHITE, 0.0), new Gradient.GradientColor(Color.YELLOW, 0.5), new Gradient.GradientColor(Color.RED, 1.0)});
    private static final Gradient SAFE_GRADIENT = new Gradient(new Gradient.GradientColor[]{new Gradient.GradientColor(Color.GREEN, 0.0), new Gradient.GradientColor(Color.YELLOW, 0.5), new Gradient.GradientColor(Color.RED, 1.0)});
    private static final Gradient SAFE_DISCRETE_GRADIENT = new Gradient(new Gradient.GradientColor[]{new Gradient.GradientColor(Color.GREEN, 0.0), new Gradient.GradientColor(Color.GREEN, 0.649999999), new Gradient.GradientColor(Color.YELLOW, 0.65), new Gradient.GradientColor(Color.YELLOW, 0.874999999), new Gradient.GradientColor(Color.RED, 0.875), new Gradient.GradientColor(Color.RED, 1.0)});
    private Graphics2D g;
    private LinkedList<Color> colorStack;

    public G(Graphics2D graphics2D) {
        this.g = graphics2D;
        this.colorStack = new LinkedList();
        this.colorStack.add(graphics2D.getColor());
    }

    public void pushColor(Color color) {
        this.colorStack.push(color);
        this.g.setColor(color);
    }

    public void popColor() {
        if (this.colorStack.size() <= 1) {
            throw new IllegalStateException();
        }
        this.colorStack.pop();
        this.g.setColor(this.colorStack.peek());
    }

    public Shape getRectShape(Point point, double d, double d2) {
        return new Rectangle2D.Double(point.x, point.y, d, d2);
    }

    public Shape getSquareShape(Point point, double d) {
        return this.getRectShape(point, d, d);
    }

    public Shape getCenteredSquareShape(Point point, double d) {
        return this.getSquareShape(new Point(point.x - d * 0.5, point.y - d * 0.5), d);
    }

    public void drawPoint(Point point, double d) {
        this.g.draw(this.getCenteredSquareShape(point, d));
    }

    public void drawPoint(Point point, double d, Color color) {
        this.pushColor(color);
        this.drawPoint(point, d);
        this.popColor();
    }

    public static Color getDangerColor(double d) {
        return DANGER_GRADIENT.evaluate(d);
    }
}

