/*
 * Decompiled with CFR 0.152.
 */
package deo.virtual;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class EnemyBot {
    double bearing;
    double distance;
    double heading;
    double energy;
    double height;
    double width;
    double pHeading;
    int velocity;
    String name;
    long time;

    public EnemyBot() {
        this.reset();
    }

    public int getVelocity() {
        return this.velocity;
    }

    public long getTime() {
        return this.time;
    }

    public double getPHeading() {
        return this.pHeading;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getHeadingRadians() {
        return Math.toRadians(this.heading);
    }

    public double getHeading() {
        return this.heading;
    }

    public double getBearingRadians() {
        return Math.toRadians(this.bearing);
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getBearing() {
        return this.bearing;
    }

    public String getName() {
        return this.name;
    }

    public double getBattleFieldHeight() {
        return this.height;
    }

    public double getBattleFieldWidth() {
        return this.width;
    }

    public void update(ScannedRobotEvent e, AdvancedRobot g) {
        this.pHeading = this.heading;
        this.bearing = e.getBearing();
        this.distance = e.getDistance();
        this.heading = e.getHeading();
        this.energy = e.getEnergy();
        this.velocity = (int)e.getVelocity();
        this.name = e.getName();
        this.height = g.getBattleFieldHeight();
        this.width = g.getBattleFieldWidth();
        this.time = g.getTime();
    }

    public void reset() {
        this.bearing = 0.0;
        this.distance = 0.0;
        this.heading = 0.0;
        this.energy = 0.0;
        this.velocity = 0;
        this.name = "";
    }

    public boolean isReset() {
        return this.name.equals("");
    }
}

