/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp;

import dmonner.xlbp.WeightInitializer;

public class SetWeightInitializer
implements WeightInitializer {
    private static final long serialVersionUID = 1L;
    private final float[][] w;
    private final boolean full;

    public SetWeightInitializer(float[][] w) {
        this.w = w;
        this.full = this.checkFull();
    }

    public SetWeightInitializer(float[][] w, boolean showFull) {
        this.w = w;
        this.full = showFull;
    }

    private boolean checkFull() {
        for (int j = 0; j < this.w.length; ++j) {
            for (int i = 0; i < this.w[j].length; ++i) {
                if (this.newWeight(j, i)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean fullConnectivity() {
        return this.full;
    }

    @Override
    public boolean newWeight(int j, int i) {
        float v = this.w[j][i];
        return !Float.isNaN(v) && !Float.isInfinite(v) && v != 0.0f;
    }

    @Override
    public float randomWeight(int j, int i) {
        return this.w[j][i];
    }
}

