/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.compound;

import dmonner.xlbp.Component;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.TargetComponent;
import dmonner.xlbp.compound.FunctionCompound;
import dmonner.xlbp.layer.FunctionLayer;
import dmonner.xlbp.layer.TargetLayer;
import java.util.Arrays;

public class TargetCompound
extends FunctionCompound
implements TargetComponent {
    private static final long serialVersionUID = 1L;
    private final TargetLayer target;

    public TargetCompound(String name, FunctionLayer act, TargetLayer target) {
        this(name, act, target, true);
    }

    public TargetCompound(String name, FunctionLayer act, TargetLayer target, boolean biases) {
        super(name, act, biases);
        this.target = target;
        target.addUpstream(super.getOutput());
    }

    public TargetCompound(TargetCompound that, NetworkCopier copier) {
        super(that, copier);
        this.target = copier.getCopyOf(that.target);
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            this.target.build();
            this.built = true;
        }
    }

    @Override
    public void clearActivations() {
        super.clearActivations();
        this.target.clearActivations();
    }

    @Override
    public void clearResponsibilities() {
        super.clearResponsibilities();
        this.target.clearResponsibilities();
    }

    @Override
    public TargetCompound copy(NetworkCopier copier) {
        return new TargetCompound(this, copier);
    }

    @Override
    public TargetCompound copy(String nameSuffix) {
        NetworkCopier copier = new NetworkCopier(nameSuffix);
        TargetCompound copy = this.copy(copier);
        copier.build();
        return copy;
    }

    @Override
    public Component[] getComponents() {
        Component[] comps = super.getComponents();
        comps = Arrays.copyOf(comps, comps.length + 1);
        comps[comps.length - 1] = this.target;
        return comps;
    }

    public TargetLayer getTargetLayer() {
        return this.target;
    }

    @Override
    public boolean optimize() {
        if (!super.optimize()) {
            return false;
        }
        this.target.optimize();
        return true;
    }

    @Override
    public void setTarget(float[] activations) {
        this.target.setTarget(activations);
    }

    @Override
    public void setTarget(float[] activations, float weight) {
        this.target.setTarget(activations, weight);
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        this.target.toString(sb);
        super.toString(sb);
    }

    @Override
    public void unbuild() {
        super.unbuild();
        this.target.unbuild();
    }

    @Override
    public void updateResponsibilities() {
        this.target.updateResponsibilities();
        super.updateResponsibilities();
    }
}

