/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.connection;

import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.connection.Connection;
import dmonner.xlbp.layer.WeightReceiverLayer;
import dmonner.xlbp.layer.WeightSenderLayer;

public abstract class LayerConnection
implements Connection {
    private static final long serialVersionUID = 1L;
    protected final String name;
    protected final WeightReceiverLayer to;
    protected final WeightSenderLayer from;
    protected Responsibilities dbuf;
    protected boolean built;

    public LayerConnection(LayerConnection that, NetworkCopier copier) {
        this.name = copier.getCopyNameFrom(that);
        this.to = copier.getCopyOf(that.to);
        this.from = copier.getCopyOf(that.from);
        this.built = that.built;
        if (that.built) {
            this.dbuf = copier.copyState() ? that.dbuf.copy() : new Responsibilities(that.dbuf.size());
        }
    }

    public LayerConnection(String name, WeightReceiverLayer to, WeightSenderLayer from) {
        this.name = name;
        this.to = to;
        this.from = from;
    }

    public LayerConnection(WeightReceiverLayer to, WeightSenderLayer from) {
        this(from.getName() + "To" + to.getName(), to, from);
    }

    @Override
    public void build() {
        if (!this.built) {
            this.dbuf = new Responsibilities(this.getToLayer().size());
            this.built = true;
        }
    }

    @Override
    public abstract LayerConnection copy(NetworkCopier var1);

    public abstract float[] getCachedInput();

    public WeightSenderLayer getFromLayer() {
        return this.from;
    }

    public float[] getFromLayerResponsibilities() {
        WeightSenderLayer from = this.getFromLayer();
        Responsibilities resp = from.getResponsibilities();
        resp.touch();
        return resp.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public WeightReceiverLayer getToLayer() {
        return this.to;
    }

    public float[] getToLayerResponsibilities() {
        WeightReceiverLayer to = this.getToLayer();
        if (to.getDownstreamCopyLayer() != null) {
            Responsibilities copyresp = to.getDownstreamCopyLayer().getResponsibilities();
            Responsibilities resp = to.getResponsibilities();
            this.dbuf.copyMul(copyresp, resp.get());
            return this.dbuf.get();
        }
        Responsibilities resp = to.getResponsibilities();
        if (resp.empty()) {
            return null;
        }
        return resp.get();
    }

    @Override
    public int nWeightsPossible() {
        return this.to.size() * this.from.size();
    }

    @Override
    public String toString(String show) {
        NetworkStringBuilder sb = new NetworkStringBuilder(show);
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public void unbuild() {
        this.built = false;
    }

    public abstract void updateResponsibilities();
}

