/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.FractionStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.stat.StepStat;
import dmonner.xlbp.stat.TargetSetStat;
import dmonner.xlbp.trial.Step;
import dmonner.xlbp.trial.Trial;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TrialStat
extends AbstractStat {
    private final Trial trial;
    private final List<StepStat> steps;
    private final TargetSetStat targets;
    private final FractionStat stepsCorrect;
    private final FractionStat trialCorrect;

    public TrialStat(Trial trial) {
        this.trial = trial;
        this.steps = new ArrayList<StepStat>(trial.size());
        this.targets = new TargetSetStat();
        this.stepsCorrect = new FractionStat("Steps");
        this.trialCorrect = new FractionStat("Trial");
        for (Step step : trial.getSteps()) {
            this.add(step.getLastEvaluation());
        }
        this.analyze();
    }

    @Override
    public void add(Stat that) {
        if (!(that instanceof StepStat)) {
            throw new IllegalArgumentException("Can only add in StepStats.");
        }
        this.add((StepStat)that);
    }

    public void add(StepStat step) {
        this.targets.add(step.getTargets());
        this.stepsCorrect.add(step.getCorrect());
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        this.targets.addTo(prefix, map);
        this.stepsCorrect.addTo(prefix, map);
    }

    @Override
    public void analyze() {
        this.targets.analyze();
        this.stepsCorrect.analyze();
        int correct = this.stepsCorrect.getFraction() == 1.0f ? 1 : 0;
        int possible = this.stepsCorrect.getPossible() > 0 ? 1 : 0;
        this.trialCorrect.add(correct, possible);
        this.trialCorrect.analyze();
    }

    @Override
    public void clear() {
        this.targets.clear();
        this.stepsCorrect.clear();
        this.trialCorrect.clear();
    }

    public List<StepStat> getSteps() {
        return this.steps;
    }

    public FractionStat getStepsCorrect() {
        return this.stepsCorrect;
    }

    public TargetSetStat getTargets() {
        return this.targets;
    }

    public Trial getTrial() {
        return this.trial;
    }

    public FractionStat getTrialCorrect() {
        return this.trialCorrect;
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        this.trialCorrect.saveData(out);
        this.stepsCorrect.saveData(out);
        this.targets.saveData(out);
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        this.trialCorrect.saveHeader(prefix, out);
        this.stepsCorrect.saveHeader(prefix, out);
        this.targets.saveHeader(prefix, out);
    }

    protected void saveMetaData(CSVWriter out) throws IOException {
        out.beginRecord();
        this.trialCorrect.saveData(out);
        this.stepsCorrect.saveData(out);
        this.targets.saveData(out);
    }

    protected void saveMetaHeader(CSVWriter out) throws IOException {
        out.beginRecord();
        this.trialCorrect.saveHeader(out);
        this.stepsCorrect.saveHeader(out);
        this.targets.saveHeader(out);
    }

    public int size() {
        return this.steps.size();
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.trialCorrect.toString(prefix));
        sb.append(this.stepsCorrect.toString(prefix));
        sb.append(this.targets.toString(prefix));
        return sb.toString();
    }
}

