/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.util;

import dmonner.xlbp.util.IndexAwareHeap;
import java.util.Comparator;

public class IndexAwareHeapNode<E extends Comparable<E>>
implements Comparable<IndexAwareHeapNode<E>> {
    private IndexAwareHeap<E> heap = null;
    private int index;
    public final E element;

    public IndexAwareHeapNode(E elem) {
        this.element = elem;
        this.index = -1;
    }

    @Override
    public int compareTo(IndexAwareHeapNode<E> that) {
        Comparator<E> comp = this.heap.getComparator();
        if (comp == null) {
            return this.element.compareTo(that.element);
        }
        return comp.compare(this.element, that.element);
    }

    public IndexAwareHeap<E> getHeap() {
        return this.heap;
    }

    public int getIndex() {
        return this.index;
    }

    public void remove() {
        this.heap.remove(this.index);
    }

    public void set(IndexAwareHeap<E> heap, int index) {
        this.heap = heap;
        this.index = index;
    }

    public String toString() {
        return "[" + this.index + ": " + this.element.toString() + "]";
    }
}

