/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;

public class ListSet<E>
implements Set<E>,
List<E> {
    private final Set<E> set;
    private final List<E> list;

    public ListSet() {
        this.set = new TreeSet();
        this.list = new LinkedList();
    }

    private ListSet(List<E> list, Set<E> set) {
        this.set = set;
        this.list = list;
    }

    public ListSet(ListSet<E> other) {
        this.set = new TreeSet<E>(other.set);
        this.list = new LinkedList<E>(other.list);
    }

    public ListSet(Set<E> other) {
        this.set = new TreeSet<E>(other);
        this.list = new LinkedList<E>(other);
    }

    @Override
    public boolean add(E e) {
        if (!this.set.contains(e)) {
            this.list.add(e);
            return this.set.add(e);
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        if (!this.set.contains(element)) {
            this.list.add(index, element);
            this.set.add(element);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int inserted = 0;
        for (E e : c) {
            if (this.set.contains(e)) continue;
            this.list.add(index + inserted, e);
            this.set.add(e);
            ++inserted;
        }
        return inserted > 0;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public E remove(int index) {
        E e = this.list.remove(index);
        if (e != null) {
            this.set.remove(e);
        }
        return e;
    }

    @Override
    public boolean remove(Object o) {
        this.list.remove(o);
        return this.set.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.list.removeAll(c);
        return this.set.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.list.retainAll(c);
        return this.set.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        E old = this.list.set(index, element);
        this.set.remove(old);
        this.set.add(element);
        return old;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public ListSet<E> subList(int fromIndex, int toIndex) {
        List<E> sublist = this.list.subList(fromIndex, toIndex);
        TreeSet<E> subset = new TreeSet<E>(this.set);
        subset.retainAll(sublist);
        return new ListSet<E>(sublist, subset);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }
}

