/*
 * Decompiled with CFR 0.152.
 */
package adt;

import adt.Context;
import adt.RobotMemory;
import adt.RobotMemoryEntry;
import java.awt.geom.Point2D;
import java.util.ListIterator;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class SLP_RobotMemory
extends RobotMemory {
    boolean stationary = true;
    double ax;
    double bx;
    double ay;
    double by;
    double maxVelocityError = 2.0;
    Context my;

    public SLP_RobotMemory(Robot self, String name, Context my) {
        super(self, name);
        this.my = my;
    }

    public void update(long t, Object eventData, Point2D.Double position) {
        if (this.entries.size() > 0) {
            if (this.stationary) {
                RobotMemoryEntry thisMemoryEntry = (RobotMemoryEntry)this.entries.getFirst();
                if (((ScannedRobotEvent)thisMemoryEntry.getEvent()).getVelocity() > 0.0) {
                    this.stationary = false;
                    this.estimateMovementFromLastScan(thisMemoryEntry);
                } else if (this.entries.size() > 1 && position.distance(thisMemoryEntry.getPosition()) > this.maxVelocityError) {
                    this.stationary = false;
                    this.doLinearRegression();
                }
            } else {
                RobotMemoryEntry thisMemoryEntry = (RobotMemoryEntry)this.entries.getFirst();
                long old = thisMemoryEntry.getTime();
                if (position.distance(this.predictPosition(t)) > this.maxVelocityError * (double)(t - old)) {
                    this.doLinearRegression();
                }
            }
        }
        super.update(t, eventData, position);
    }

    public Point2D.Double getAimPoint() {
        Point2D.Double posn;
        if (this.stationary) {
            return super.getAimPoint();
        }
        double flightTime = 1.0;
        Point2D.Double newPosn = this.predictPosition((long)((double)this.self.getTime() + flightTime));
        double speed = 19.7;
        int itter = 50;
        do {
            posn = newPosn;
            flightTime = posn.distance(this.my.x + this.my.vx * 3.0, this.my.y + this.my.vy * 3.0) / speed;
            newPosn = this.predictPosition((long)((double)this.self.getTime() + flightTime));
        } while (--itter > 0 && newPosn.distance(posn) > 10.0);
        return newPosn;
    }

    public Point2D.Double predictPosition(long t) {
        double x = this.ax * (double)t + this.bx;
        double y = this.ay * (double)t + this.by;
        if (x < 20.0) {
            x = 20.0;
        } else if (x > this.self.getBattleFieldWidth() - 20.0) {
            x = this.self.getBattleFieldWidth() - 20.0;
        }
        if (y < 20.0) {
            y = 20.0;
        } else if (y > this.self.getBattleFieldHeight() - 20.0) {
            y = this.self.getBattleFieldHeight() - 20.0;
        }
        Point2D.Double pos = new Point2D.Double(x, y);
        return pos;
    }

    public void estimateMovementFromLastScan(RobotMemoryEntry memory) {
        ScannedRobotEvent lastScan = (ScannedRobotEvent)memory.getEvent();
        this.ax = lastScan.getVelocity() * Math.sin(lastScan.getHeadingRadians());
        this.ay = lastScan.getVelocity() * Math.cos(lastScan.getHeadingRadians());
        this.bx = memory.getPosition().getX() - (double)memory.getTime() * this.ax;
        this.by = memory.getPosition().getY() - (double)memory.getTime() * this.ay;
    }

    public void doLinearRegression() {
        int n = 0;
        int el = 0;
        double sig_tx = 0.0;
        double sig_t = 0.0;
        double sig_x = 0.0;
        double sig_t_sq = 0.0;
        double sig_ty = 0.0;
        double sig_y = 0.0;
        ListIterator thisIter = this.entries.listIterator(0);
        while (thisIter.hasNext()) {
            RobotMemoryEntry entry = (RobotMemoryEntry)thisIter.next();
            if (el++ > 2) break;
            ++n;
            sig_tx += entry.getPosition().getX() * (double)entry.getTime();
            sig_ty += entry.getPosition().getY() * (double)entry.getTime();
            sig_t += (double)entry.getTime();
            sig_t_sq += (double)(entry.getTime() * entry.getTime());
            sig_x += entry.getPosition().getX();
            sig_y += entry.getPosition().getY();
        }
        double divisor = (double)n * sig_t_sq - sig_t * sig_t;
        this.ax = ((double)n * sig_tx - sig_t * sig_x) / divisor;
        this.ay = ((double)n * sig_ty - sig_t * sig_y) / divisor;
        this.bx = (sig_x * sig_t_sq - sig_t * sig_tx) / divisor;
        this.by = (sig_y * sig_t_sq - sig_t * sig_ty) / divisor;
    }
}

