/*
 * Decompiled with CFR 0.152.
 */
package suzushin7.nano;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Galaxy03
extends AdvancedRobot {
    public static final double BULLET_POWER = 3.0;
    public static final double BULLET_VELOCITY = 11.0;
    private static double lastEnemyHeading;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
        double absBearing = this.getHeadingRadians() + e.getBearingRadians();
        double predictedX = this.getX() + e.getDistance() * Math.sin(absBearing);
        double predictedY = this.getY() + e.getDistance() * Math.cos(absBearing);
        double enemyHeading = e.getHeadingRadians();
        double enemyHeadingChange = e.getHeadingRadians() - lastEnemyHeading;
        double dt = 0.0;
        while (true) {
            double d;
            dt += 1.0;
            if (!(11.0 * d < Point2D.distance(this.getX(), this.getY(), predictedX, predictedY))) break;
            predictedX += e.getVelocity() * Math.sin(enemyHeading);
            predictedY += e.getVelocity() * Math.cos(enemyHeading);
            enemyHeading += enemyHeadingChange;
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(predictedX - this.getX(), predictedY - this.getY()) - this.getGunHeadingRadians())));
        this.setFire(3.0);
        lastEnemyHeading = e.getHeadingRadians();
        this.setTurnRightRadians(e.getBearingRadians());
        this.setAhead(100.0);
    }
}

