/*
 * Decompiled with CFR 0.152.
 */
package kid.movement.robot;

import java.awt.geom.Point2D;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import kid.data.Printable;
import kid.data.factor.GuessFactor;
import kid.info.RobotInfo;
import kid.movement.MovementProfiler;
import kid.movement.robot.Movement;
import kid.robot.RobotData;
import kid.robot.RobotVector;
import kid.utils.Utils;
import kid.virtual.DataWave;
import kid.virtual.VirtualBullet;
import kid.virtual.VirtualWave;
import robocode.Event;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;

public class Perpendicular
extends Movement {
    private static final long serialVersionUID = 4332573743463836316L;
    private double safeDistance;
    private Point2D[] forwards = new Point2D[0];
    private Point2D[] stop = new Point2D[0];
    private Point2D[] backwards = new Point2D[0];
    private int points = 1;

    public Perpendicular(Robot myRobot) {
        super(myRobot);
        this.init(myRobot);
    }

    private void init(Robot myRobot) {
        this.safeDistance = Math.min(1200.0, Math.min(this.info.getBattleFieldHeight(), this.info.getBattleFieldWidth())) * 0.7;
    }

    public void move(RobotData enemy, MovementProfiler profile) {
        ArrayList<DataWave<GuessFactor, RobotData, RobotData>> enemyWaves = profile.getWaves();
        double targetVelocity = (double)Utils.sign(this.info.getMoveRemaining()) * 8.0;
        double x = this.info.getX();
        double y = this.info.getY();
        long time = this.info.getTime();
        VirtualWave wave = null;
        if (enemyWaves.size() > 0) {
            wave = enemyWaves.get(0);
            for (VirtualWave virtualWave : enemyWaves) {
                if (!(virtualWave.getDistToImpact(x, y, time) < wave.getDistToImpact(x, y, time))) continue;
                wave = virtualWave;
            }
        }
        if (wave != null && enemy.distSq(x, y) > 40000.0) {
            double backwardsDanger;
            double stopDanger;
            this.forwards = this.getImpactPoints((double)Utils.sign(this.info.getMoveRemaining()) * 8.0, enemyWaves, this.points);
            this.stop = this.getImpactPoints(0.0, enemyWaves, this.points);
            this.backwards = this.getImpactPoints((double)(-Utils.sign(this.info.getMoveRemaining())) * 8.0, enemyWaves, this.points);
            double d = this.getDanger(this.forwards, enemyWaves, profile.getLatest(), profile.getLatestHits());
            double minDanger = Math.min(d, Math.min(stopDanger = this.getDanger(this.stop, enemyWaves, profile.getLatest(), profile.getLatestHits()), backwardsDanger = this.getDanger(this.backwards, enemyWaves, profile.getLatest(), profile.getLatestHits())));
            if (minDanger == stopDanger) {
                targetVelocity = 0.0;
            } else if (minDanger == backwardsDanger) {
                targetVelocity = (double)(-Utils.sign(this.info.getMoveRemaining())) * 8.0;
            }
            this.movement.setAhead(targetVelocity * Double.POSITIVE_INFINITY);
            this.movement.setTurnPerpenToXYwBFwDCwRM(wave.getStartX(), wave.getStartY(), this.safeDistance);
        } else {
            this.movement.setAhead((double)this.movement.setTurnPerpenToRobotwBFwDC(enemy, this.safeDistance) * Double.POSITIVE_INFINITY);
        }
        this.movement.setSmoothWalls();
    }

    private double getDanger(Point2D[] position, ArrayList<DataWave<GuessFactor, RobotData, RobotData>> enemyWaves, GuessFactor[] latest, GuessFactor[] latestHits) {
        double danger = Double.NEGATIVE_INFINITY;
        if (position.length > 0) {
            danger = 0.0;
            long time = this.info.getTime();
            LinkedList sorted = new LinkedList();
            for (DataWave<GuessFactor, RobotData, RobotData> w : enemyWaves) {
                ListIterator<DataWave<GuessFactor, RobotData, RobotData>> iter = sorted.listIterator();
                boolean added = false;
                while (iter.hasNext() && !added) {
                    DataWave i = (DataWave)iter.next();
                    if (!(w.getDistSq(time) >= i.getDistSq(time))) continue;
                    iter.previous();
                    iter.add(w);
                    added = true;
                }
                if (added) continue;
                iter.add(w);
            }
            while (sorted.peekFirst() != null && ((DataWave)sorted.peekFirst()).getDistToImpact(position[0].getX(), position[0].getY(), time) < 0.0) {
                sorted.removeFirst();
            }
            double[][] waveBins = new double[sorted.size()][101];
            int i = 0;
            while (i < waveBins.length) {
                DataWave<GuessFactor, RobotData, RobotData> wave = enemyWaves.get(i);
                int j = 0;
                while (j < waveBins[i].length) {
                    GuessFactor gf;
                    GuessFactor[] guessFactorArray = (GuessFactor[])wave.getData();
                    int n = guessFactorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        gf = guessFactorArray[n2];
                        double[] dArray = waveBins[i];
                        int n3 = j;
                        dArray[n3] = dArray[n3] + Utils.limit(0.0, 10.0 / (50.0 * Utils.sqr(Utils.getGuessFactor(j, waveBins[i].length) - gf.getGuessFactor()) + 1.0) - 4.99, 5.0);
                        ++n2;
                    }
                    guessFactorArray = latest;
                    n = latest.length;
                    n2 = 0;
                    while (n2 < n) {
                        gf = guessFactorArray[n2];
                        if (gf != null) {
                            double[] dArray = waveBins[i];
                            int n4 = j;
                            dArray[n4] = dArray[n4] + Utils.limit(0.0, 10.0 / (50.0 * Utils.sqr(Utils.getGuessFactor(j, waveBins[i].length) - gf.getGuessFactor()) + 1.0) - 4.99, 5.0);
                        }
                        ++n2;
                    }
                    guessFactorArray = latestHits;
                    n = latestHits.length;
                    n2 = 0;
                    while (n2 < n) {
                        gf = guessFactorArray[n2];
                        if (gf != null) {
                            double[] dArray = waveBins[i];
                            int n5 = j;
                            dArray[n5] = dArray[n5] + Utils.limit(0.0, 10.0 / (50.0 * Utils.sqr(Utils.getGuessFactor(j, waveBins[i].length) - gf.getGuessFactor()) + 1.0) - 4.99, 5.0);
                        }
                        ++n2;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (sorted.size() > 0 && i < position.length) {
                double pointDanger = 0.0;
                double x = position[i].getX();
                double y = position[i].getY();
                int j = 0;
                while (j < sorted.size()) {
                    double waveDanger = 0.0;
                    DataWave w = (DataWave)sorted.get(j);
                    double dist = Utils.dist(x, y, w.getStartX(), w.getStartY());
                    int index = Utils.getIndex(Utils.getGuessFactor(w, (RobotData)w.getView(), x, y), waveBins[j].length);
                    int indexWidth = Utils.getIndex(Utils.atan(18.0 / dist) / w.getMaxEscapeAngle(), waveBins[j].length) - Utils.getIndex(0.0, waveBins[j].length);
                    int k = Math.max(index -= indexWidth, 0);
                    while (k <= Math.min(index + 2 * indexWidth, waveBins[j].length - 1)) {
                        waveDanger += waveBins[j][k];
                        ++k;
                    }
                    pointDanger += (waveDanger /= w.getDistToImpact(x, y, time));
                    ++j;
                }
                sorted.remove();
                danger += (pointDanger /= Utils.sqr(i + 1));
                ++i;
            }
        }
        return danger;
    }

    private Point2D[] getImpactPoints(double targetVelocity, ArrayList<DataWave<GuessFactor, RobotData, RobotData>> enemyWaves, int n) {
        Point2D[] points = new Point2D[Math.min(enemyWaves.size(), n)];
        if (enemyWaves.size() > 0) {
            VirtualWave[] waves = new VirtualWave[enemyWaves.size()];
            int i = 0;
            while (i < enemyWaves.size()) {
                waves[i] = enemyWaves.get(i);
                ++i;
            }
            double x = this.info.getX();
            double y = this.info.getY();
            double h = this.info.getHeading();
            double v = this.info.getVelocity();
            if (targetVelocity < 0.0) {
                h = Utils.oppositeRelative(h);
                v = -v;
                targetVelocity = -targetVelocity;
            }
            long time = this.info.getTime() + 2L;
            double bfw = this.info.getBattleFieldWidth();
            double bfh = this.info.getBattleFieldHeight();
            int i2 = 0;
            while (i2 < points.length) {
                boolean hit = false;
                while (!hit) {
                    h = this.movement.setSmoothWalls(x, y, h);
                    v = RobotInfo.getFutureVelocity(v, targetVelocity);
                    x += Utils.getDeltaX(v, h);
                    y += Utils.getDeltaY(v, h);
                    x = Utils.limit(RobotInfo.MIN_WALL_DIST, x, bfw - RobotInfo.MIN_WALL_DIST);
                    y = Utils.limit(RobotInfo.MIN_WALL_DIST, y, bfh - RobotInfo.MIN_WALL_DIST);
                    ++time;
                    int j = 0;
                    while (j < waves.length - i2) {
                        VirtualWave w = waves[j];
                        if (w.getDistSq(time) > Utils.distSq(w.getStartX(), w.getStartY(), x, y)) {
                            hit = true;
                            VirtualWave temp = waves[waves.length - (i2 + 1)];
                            waves[waves.length - (i2 + 1)] = w;
                            waves[j] = temp;
                        }
                        ++j;
                    }
                }
                points[i2] = new Point2D.Double(x, y);
                ++i2;
            }
        }
        return points;
    }

    @Override
    public void move(RobotData[] robots, VirtualBullet[] teammateBullets) {
        long time = this.robot.getTime();
        double perpenAngle = 0.0;
        double totalWeight = 0.0;
        double minDist = Double.POSITIVE_INFINITY;
        Printable[] printableArray = robots;
        int n = robots.length;
        int n2 = 0;
        while (n2 < n) {
            RobotData r = printableArray[n2];
            if (!r.isDead()) {
                minDist = Math.min(this.info.distSq(r), minDist);
                double robotAngle = Utils.absolute(this.info.angle(r)) % 180.0;
                double robotWeight = r.getEnergy() / this.info.distSq(r);
                perpenAngle += robotAngle * robotWeight;
                totalWeight += robotWeight;
            }
            ++n2;
        }
        printableArray = teammateBullets;
        n = teammateBullets.length;
        n2 = 0;
        while (n2 < n) {
            Printable b = printableArray[n2];
            minDist = Math.min(this.info.distSq(((VirtualBullet)b).getX(time), ((VirtualBullet)b).getY(time)), minDist);
            double bulletAngle = Utils.absolute(this.info.angle(((VirtualBullet)b).getX(time), ((VirtualBullet)b).getY(time))) % 180.0;
            double bulletWeight = 1000.0 / Utils.sqr(this.info.distSq(((VirtualBullet)b).getX(time), ((VirtualBullet)b).getY(time)));
            perpenAngle += bulletAngle * bulletWeight;
            totalWeight += bulletWeight;
            ++n2;
        }
        if (totalWeight != 0.0) {
            double safedist = this.safeDistance / Math.max((double)this.info.getOthers() / 3.0, 1.0);
            this.movement.setAhead(Double.POSITIVE_INFINITY * (double)this.movement.setTurnPerpenToAnglewBFwDC(perpenAngle /= totalWeight, Utils.sqrt(minDist), safedist));
            this.movement.setSmoothWalls();
        }
    }

    public RobotVector move(RobotVector myRobot, RobotData[] robots) {
        double perpenAngle = 0.0;
        double totalWeight = 0.0;
        double minRobotDist = Double.POSITIVE_INFINITY;
        RobotData[] robotDataArray = robots;
        int n = robots.length;
        int n2 = 0;
        while (n2 < n) {
            RobotData r = robotDataArray[n2];
            if (!r.isDead()) {
                minRobotDist = Math.min(this.info.distSq(r), minRobotDist);
                double robotAngle = Utils.absolute(Utils.angle(myRobot.getX(), myRobot.getY(), r.getX(), r.getY())) % 180.0;
                double robotWeight = r.getEnergy() / Utils.distSq(myRobot.getX(), myRobot.getY(), r.getX(), r.getY());
                perpenAngle += robotAngle * robotWeight;
                totalWeight += robotWeight;
            }
            ++n2;
        }
        if (totalWeight != 0.0) {
            perpenAngle /= totalWeight;
        }
        return null;
    }

    @Override
    public Point2D[] getMove(RobotData[] robots, VirtualBullet[] teammateBullets, long time) {
        return null;
    }

    @Override
    public void inEvent(Event event) {
    }

    @Override
    public String getName() {
        return new String("Perpendicular Movement");
    }

    @Override
    public String getType() {
        return new String("One-On-One Movement");
    }

    @Override
    public void print(PrintStream console) {
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }
}

