/*
 * Decompiled with CFR 0.152.
 */
package rdt199.gun;

import rdt199.gun.GunMode;
import rdt199.util.Location;
import rdt199.util.RobotLog;
import rdt199.util.RobotSnapshot;

public class HistoryMatchMode
extends GunMode {
    protected static int MATCH_SIZE = 8;
    protected static int PREDICTION_MINIMUM = 90;

    public HistoryMatchMode(RobotLog log) {
        super(log);
    }

    public HistoryMatchMode(RobotLog log, String prefix) {
        super(log, prefix);
        this.loadData(String.valueOf(this.m_Prefix) + "hm");
    }

    protected Location getPrediction(long time) {
        int iMatchIndex = this.getBestMatchIndex();
        if (iMatchIndex < PREDICTION_MINIMUM && (long)iMatchIndex > time) {
            return this.m_Log.get((int)0).m_Location;
        }
        int iCurrentIndex = iMatchIndex;
        double dDeltaX = 0.0;
        double dDeltaY = 0.0;
        double dHeading = this.m_Log.get((int)0).m_dAngle;
        int iCount = 0;
        while ((long)iCount < time) {
            RobotSnapshot Snap = this.m_Log.get(iCurrentIndex);
            if (Snap == null) {
                return this.m_Log.get((int)0).m_Location;
            }
            dDeltaX += Snap.m_dVelocity * Math.sin(Math.toRadians(dHeading += Snap.m_dDeltaAngle));
            dDeltaY += Snap.m_dVelocity * Math.cos(Math.toRadians(dHeading));
            --iCurrentIndex;
            ++iCount;
        }
        return new Location(this.m_Log.get((int)0).m_Location.getX() + dDeltaX, this.m_Log.get((int)0).m_Location.getY() + dDeltaY);
    }

    public double getScore() {
        return this.getPercentage();
    }

    public void close() {
        this.saveData(String.valueOf(this.m_Prefix) + "hm");
    }

    protected int getBestMatchIndex() {
        if (this.m_Log.getSnapshotSize() < MATCH_SIZE + 1) {
            return -1;
        }
        double dBestScore = 0.0;
        int iBestOffset = -1;
        int iOffset = MATCH_SIZE;
        while (iOffset < this.m_Log.getSnapshotSize()) {
            double dCurrentScore = 0.0;
            int iCount = 0;
            while (iCount < MATCH_SIZE) {
                RobotSnapshot SnapPattern = this.m_Log.get(iCount);
                RobotSnapshot SnapHistory = this.m_Log.get(iCount + iOffset);
                if (SnapPattern != null && SnapHistory != null) {
                    dCurrentScore += SnapPattern.similar(SnapHistory);
                }
                ++iCount;
            }
            if (dCurrentScore >= dBestScore) {
                dBestScore = dCurrentScore;
                iBestOffset = iOffset;
            }
            ++iOffset;
        }
        return iBestOffset;
    }
}

