/*
 * Decompiled with CFR 0.152.
 */
package gtf.robocode.motor;

import gtf.robocode.Util;
import gtf.robocode.Vector2D;
import gtf.robocode.forcefield.ForceField;
import gtf.robocode.motor.Motor;
import robocode.AdvancedRobot;
import robocode.HitWallEvent;

public class ComboMotor
extends Motor {
    double speed = 100.0;
    double randomTurn = 60.0;
    static final double THRESHOLD = 1.0;
    protected ForceField field;

    public ComboMotor(AdvancedRobot robot, ForceField field) {
        super(robot);
        this.field = field;
    }

    public void doMotion() {
        Vector2D force = this.field.getVector2D(this.robot.getX(), this.robot.getY());
        double oldHeading = this.robot.getHeading();
        double newHeading = force.norm() > 1.0 ? Math.toDegrees(force.toPolar().theta) : oldHeading + (Math.random() * 2.0 - 1.0) * this.randomTurn;
        this.robot.setAhead(this.speed);
        double turn = Util.normalize(newHeading - oldHeading);
        this.robot.setTurnRight(turn);
    }

    public void onHitWall(HitWallEvent e) {
        double bearing = e.getBearing();
        if (0.0 <= bearing) {
            this.robot.setTurnLeft(180.0 - 2.0 * bearing);
        } else {
            this.robot.setTurnRight(180.0 + 2.0 * bearing);
        }
    }
}

