/*
 * Decompiled with CFR 0.152.
 */
package pedersen.movement;

import pedersen.core.Combatant;
import pedersen.debug.DebuggableBase;
import pedersen.divination.CombatWave;
import pedersen.divination.CombatWaveBank;
import pedersen.opponent.Target;
import pedersen.physics.Position;
import pedersen.physics.Snapshot;
import pedersen.physics.Vehicle;
import pedersen.systems.TurretSubsystem;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.systems.notifier.OnHitByBullet;
import pedersen.systems.notifier.OnRound;
import pedersen.systems.notifier.OnTurn;
import pedersen.systems.notifier.OnWaveCountChange;

public abstract class MovementMethodBase
extends DebuggableBase
implements OnRound,
OnTurn,
OnHitByBullet,
OnWaveCountChange {
    private int timeInUse = 0;
    private int hitTally = 0;
    private boolean isActive = false;
    private static boolean isWaveInbound = false;

    protected MovementMethodBase() {
        NotificationSubsystem.getInstance().subscribeOnRound(this);
        NotificationSubsystem.getInstance().subscribeOnTurn(this);
        NotificationSubsystem.getInstance().subscribeOnHitByBullet(this);
        NotificationSubsystem.getInstance().subscribeOnInboundWaveCountChange(this);
    }

    protected Vehicle getCombatantSnapshot() {
        return Combatant.getCombatant().getChassis();
    }

    protected Snapshot getTargetSnapshot() {
        Snapshot snapshot = null;
        Target target = TurretSubsystem.getInstance().getTarget();
        if (target != null && target.isActive()) {
            snapshot = target.getSnapshot();
        }
        return snapshot;
    }

    protected Position getTargetPosition() {
        Position position = null;
        Target target = TurretSubsystem.getInstance().getTarget();
        if (target != null) {
            position = target.getPosition();
        }
        return position;
    }

    public int getTimeInUse() {
        return this.timeInUse;
    }

    public int getHitTally() {
        return this.hitTally;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void activate() {
        this.isActive = true;
    }

    public void deactivate() {
        this.isActive = false;
    }

    public boolean isWaveInbound() {
        return isWaveInbound;
    }

    private void setIsWaveInbound(boolean waveInboundStatus) {
        isWaveInbound = waveInboundStatus;
    }

    @Override
    public void onRound(int round) {
        if (this.isActive()) {
            this.deactivate();
        }
    }

    @Override
    public void onTurn(long time) {
        if (this.isActive() && this.isWaveInbound()) {
            ++this.timeInUse;
        }
    }

    @Override
    public void onHitByBullet(CombatWave wave) {
        if (this.isActive()) {
            ++this.hitTally;
        }
    }

    @Override
    public void onWaveCountChange() {
        this.setIsWaveInbound(CombatWaveBank.getInstance().isWaveInbound());
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        if (this.timeInUse == 0) {
            buffer.append(" has not been not used.");
        } else if (this.hitTally == 0) {
            buffer.append(" has not been hit over " + this.timeInUse + " ticks.");
        } else {
            buffer.append(": Hits: " + this.hitTally + ", Time in Use: " + this.timeInUse + ", Average t/h: " + super.trim((double)this.timeInUse / (double)this.hitTally));
        }
        return buffer.toString();
    }
}

