/*
 * Decompiled with CFR 0.152.
 */
package pedersen.movement.absolute;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import pedersen.core.GameState;
import pedersen.debug.renderable.GraphicalDebugger;
import pedersen.divination.CombatWaveBank;
import pedersen.movement.MovementMethod;
import pedersen.movement.absolute.MovementMethodAbsoluteBase;
import pedersen.movement.absolute.MovementMethodUnpinImpl;
import pedersen.movement.vectorsum.MovementMethodFullThrottleImpl;
import pedersen.physics.DistanceVector;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.Position;
import pedersen.physics.Vehicle;
import pedersen.physics.constant.DistanceVectorImpl;
import pedersen.physics.constant.VehicleImpl;
import pedersen.util.Constraints;

public class MovementMethodGridImpl
extends MovementMethodAbsoluteBase
implements MovementMethod {
    private static final MovementMethod singleton = new MovementMethodGridImpl();
    private static List<DistanceVector> relativePositions = MovementMethodGridImpl.getRelativePositions();
    private Vehicle destination = null;

    @Override
    public Vehicle getDestination() {
        Position targetPosition = super.getTargetPosition();
        if (GameState.getInstance().isGunCool()) {
            this.destination = MovementMethodUnpinImpl.getInstance().getDestination();
            GraphicalDebugger.drawMarker(this.destination.getPosition(), Color.cyan);
        } else if (!CombatWaveBank.getInstance().isWaveInbound()) {
            this.destination = MovementMethodFullThrottleImpl.getInstance().getDestination();
        } else if (this.destination == null) {
            this.destination = this.getDestination(super.getCombatantSnapshot(), targetPosition, GameState.getInstance().getTurn());
        }
        if (this.destination == null) {
            this.destination = MovementMethodFullThrottleImpl.getInstance().getDestination();
            predictedMovementVectors.clear();
            predictedPositions.clear();
        }
        return this.destination;
    }

    private Vehicle getDestination(Vehicle chassis, Position targetPosition, long time) {
        VehicleImpl destination = null;
        boolean isDestinationViable = false;
        ArrayList<DistanceVector> eligibleSectors = new ArrayList<DistanceVector>(relativePositions);
        while (eligibleSectors.size() > 0 && !isDestinationViable) {
            int value = (int)(Math.random() * (double)eligibleSectors.size());
            DistanceVector vector = (DistanceVector)eligibleSectors.get(value);
            eligibleSectors.remove(value);
            destination = new VehicleImpl((HasPosition)chassis.getPosition().addVector(vector), (HasDirection)vector.getDirection(), Constraints.maxAbsVehicleVelocity);
            isDestinationViable = super.isDestinationViable(time, chassis, destination, targetPosition);
            if (isDestinationViable) continue;
            destination = null;
        }
        return destination;
    }

    public static MovementMethod getInstance() {
        return singleton;
    }

    private static List<DistanceVector> getRelativePositions() {
        ArrayList<DistanceVector> relativePositions = new ArrayList<DistanceVector>();
        MovementMethodGridImpl.populateRelativePositions(relativePositions, 8.0, 54.0);
        MovementMethodGridImpl.populateRelativePositions(relativePositions, 16.0, 108.0);
        MovementMethodGridImpl.populateRelativePositions(relativePositions, 24.0, 162.0);
        MovementMethodGridImpl.populateRelativePositions(relativePositions, 32.0, 216.0);
        MovementMethodGridImpl.populateRelativePositions(relativePositions, 40.0, 270.0);
        return relativePositions;
    }

    private static void populateRelativePositions(List<DistanceVector> relativePositions, double slices, double radius) {
        double slice = Math.PI * 2 / slices;
        double i = 0.0;
        while (i < slices) {
            relativePositions.add(new DistanceVectorImpl(i * slice, radius));
            i += 1.0;
        }
    }

    @Override
    public void onRound(int round) {
        super.onRound(round);
        this.destination = null;
    }

    @Override
    public void onWaveCountChange() {
        super.onWaveCountChange();
        if (this.isActive()) {
            this.destination = null;
        }
    }
}

