/*
 * Decompiled with CFR 0.152.
 */
package pedersen.movement.absolute;

import java.awt.Color;
import pedersen.core.GameState;
import pedersen.debug.renderable.GraphicalDebugger;
import pedersen.divination.CombatWaveBank;
import pedersen.movement.MovementMethod;
import pedersen.movement.absolute.MovementMethodAbsoluteBase;
import pedersen.movement.absolute.MovementMethodUnpinImpl;
import pedersen.movement.vectorsum.MovementMethodFullThrottleImpl;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.Position;
import pedersen.physics.Vehicle;
import pedersen.physics.constant.PositionImpl;
import pedersen.physics.constant.VehicleImpl;
import pedersen.util.Arena;
import pedersen.util.Constraints;

public class MovementMethodRandomPointImpl
extends MovementMethodAbsoluteBase
implements MovementMethod {
    private static final MovementMethod singleton = new MovementMethodRandomPointImpl();
    private Vehicle destination = null;

    public static MovementMethod getInstance() {
        return singleton;
    }

    @Override
    public Vehicle getDestination() {
        Position targetPosition = super.getTargetPosition();
        if (GameState.getInstance().getTurn() < 31L) {
            this.destination = MovementMethodUnpinImpl.getInstance().getDestination();
            GraphicalDebugger.drawMarker(this.destination.getPosition(), Color.cyan);
        } else if (!CombatWaveBank.getInstance().isWaveInbound()) {
            this.destination = MovementMethodFullThrottleImpl.getInstance().getDestination();
        } else if (this.destination == null) {
            this.destination = this.getDestination(super.getCombatantSnapshot(), targetPosition, GameState.getInstance().getTurn());
        }
        if (this.destination == null) {
            this.destination = MovementMethodFullThrottleImpl.getInstance().getDestination();
            predictedMovementVectors.clear();
            predictedPositions.clear();
        }
        return this.destination;
    }

    private Vehicle getDestination(Vehicle chassis, Position targetPosition, long time) {
        VehicleImpl destination = null;
        boolean isDestinationViable = false;
        int i = 0;
        while (i < 50 && !isDestinationViable) {
            PositionImpl randomPoint = new PositionImpl(Math.random() * (Arena.getMaxX() - Arena.getMinX()) + Arena.getMinX(), Math.random() * (Arena.getMaxY() - Arena.getMinY()) + Arena.getMinY());
            destination = new VehicleImpl((HasPosition)randomPoint, (HasDirection)chassis.getPosition().getBearing(randomPoint), Constraints.maxAbsVehicleVelocity);
            isDestinationViable = super.isDestinationViable(time, chassis, destination, targetPosition);
            ++i;
        }
        if (!isDestinationViable) {
            destination = null;
        }
        return destination;
    }

    @Override
    public void onRound(int round) {
        super.onRound(round);
        this.destination = null;
    }

    @Override
    public void onWaveCountChange() {
        super.onWaveCountChange();
        if (this.isActive()) {
            this.destination = null;
        }
    }
}

