/*
 * Decompiled with CFR 0.152.
 */
package pedersen.movement.vector;

import pedersen.movement.vector.MovementMethodVector;
import pedersen.movement.vector.MovementMethodVectorBase;
import pedersen.physics.DistanceVector;
import pedersen.physics.HasDirection;
import pedersen.physics.Position;
import pedersen.physics.Vehicle;
import pedersen.physics.constant.PhysicsConstants;
import pedersen.util.Arena;

public class MovementMethodVectorWallImpl
extends MovementMethodVectorBase {
    private static final MovementMethodVector singleton = new MovementMethodVectorWallImpl();
    private static final double alwaysOnRangeDefault = 80.0;
    private static final double alwaysOnPowerDefault = 16.0;
    private static final double fieldMagnitudeDefault = 400.0;

    private MovementMethodVectorWallImpl() {
        super(400.0, 80.0, 16.0);
    }

    public static MovementMethodVector getInstance() {
        return singleton;
    }

    @Override
    public DistanceVector getVector() {
        Position vectorSum = PhysicsConstants.anchorPosition;
        Vehicle combatant = super.getCombatantSnapshot();
        double x = combatant.getPosition().getX();
        double y = combatant.getPosition().getY();
        vectorSum = vectorSum.addVector((HasDirection)Arena.south, this.getFieldMagnitude(Arena.getMaxY() - y));
        vectorSum = vectorSum.addVector((HasDirection)Arena.west, this.getFieldMagnitude(Arena.getMaxX() - x));
        vectorSum = vectorSum.addVector((HasDirection)Arena.north, this.getFieldMagnitude(y - Arena.getMinY()));
        vectorSum = vectorSum.addVector((HasDirection)Arena.east, this.getFieldMagnitude(x - Arena.getMinX()));
        DistanceVector movementVector = PhysicsConstants.anchorPosition.getRelativeDistanceVector(vectorSum, combatant);
        return movementVector;
    }
}

